# Google Cloud Data Catalog Lineage for PHP

> Idiomatic PHP client for [Google Cloud Data Catalog Lineage](https://cloud.google.com/data-catalog/docs/concepts/about-data-lineage).

[![Latest Stable Version](https://poser.pugx.org/google/cloud-datacatalog-lineage/v/stable)](https://packagist.org/packages/google/cloud-datacatalog-lineage) [![Packagist](https://img.shields.io/packagist/dm/google/cloud-datacatalog-lineage.svg)](https://packagist.org/packages/google/cloud-datacatalog-lineage)

* [API documentation](https://cloud.google.com/php/docs/reference/cloud-datacatalog-lineage/latest)

**NOTE:** This repository is part of [Google Cloud PHP](https://github.com/googleapis/google-cloud-php). Any
support requests, bug reports, or development contributions should be directed to
that project.

### Installation

To begin, install the preferred dependency manager for PHP, [Composer](https://getcomposer.org/).

Now install this component:

```sh
$ composer require google/cloud-datacatalog-lineage
```

> Browse the complete list of [Google Cloud APIs](https://cloud.google.com/php/docs/reference)
> for PHP

### Authentication

Please see our [Authentication guide](https://github.com/googleapis/google-cloud-php/blob/main/AUTHENTICATION.md) for more information
on authenticating your client. Once authenticated, you'll be ready to start making requests.

### Samples

See the [samples directory](samples/) for a canonical list of samples.

### Version

This component is considered alpha. As such, it is still a work-in-progress and is more likely to get backwards-incompatible updates.

### Next Steps

1. Understand the [official documentation](https://cloud.google.com/data-catalog/docs/reference/data-lineage/rest).
