<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Community_library_forma2plus_model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct(); 
        $this->table        = 'community_library_forma2plus';      
    }

    public function add($data){
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }
    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }
    public function getByAuthor($idUserCreate,$Order) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $idUserCreate);
        if (isset($Order) && $Order == 'an') {
            $this->db->order_by('name', 'asc');
        }
        elseif (isset($Order) && $Order == 'dn') {
            $this->db->order_by('name', 'desc');
        }        
        elseif (isset($Order) && $Order == 'aid') {
            $this->db->order_by('id', 'asc');
        }        
        elseif (isset($Order) && $Order == 'did') {
            $this->db->order_by('id', 'desc');
        }
        else{
            $this->db->order_by('name', 'asc');
        }
        $query = $this->db->get(); 
        return $query->result()  ; 
    }


    public function getAll($Order) {
        $this->db->select('*');
        $this->db->from($this->table);
        if (isset($Order) && $Order == 'an') {
            $this->db->order_by('name', 'asc');
        }
        elseif (isset($Order) && $Order == 'dn') {
            $this->db->order_by('name', 'desc');
        }        
        elseif (isset($Order) && $Order == 'aid') {
            $this->db->order_by('id', 'asc');
        }        
        elseif (isset($Order) && $Order == 'did') {
            $this->db->order_by('id', 'desc');
        }
        else{
            $this->db->order_by('name', 'asc');
        }
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function getByAuthorAndName($idUserCreate,$libname) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $idUserCreate);
        $this->db->where('name', $libname);
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function Request($field,$idc) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $idc);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

}

?>
