<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Documentsign_model extends CI_Model
{
    
    public function __construct(){
        parent::__construct();
        $this->table         = 'document_sign';        
        $this->table_type    = 'document_sign_type';        
        $this->table_membres = 'membres';        
        $this->table_stages  = 'stag_individu';        
    }
    public function getListByTrainne($idg){

        $this->db->select('d.id AS idDocs,t.type AS typeDocs,d.*,m.*');
        $this->db->from($this->table." as d");
        $this->db->join($this->table_membres.' as m', 'd.prop=m.id','left');
        $this->db->join($this->table_type.' as t', 't.id=d.type','left');
        $this->db->where('d.groupe', $idg);
        $this->db->where('d.priv', 0);
        return $this->db->get();   
    }
    public function getDocsByAdmin()
    {

        $this->db->select('si.id_stage_ext as num_stage,si.id_individu_ext as num_individu, m.id as stagiaireP,m.nom as stagiaireNom,m.prenom as stagiairePrenom, m.id_groupe,d.id as id, d.priv as priv,d.date_signed as date_modif, d.titre as titre, d.fichier as fichier, d.comment as comment,d.type as type_id, t.type as type, d.prop as prop, d.groupe as groupe,d.id_tuteur as tuteur_affect, d.date as date, d.tuteur_signed as tuteur_statut,d.date_envoi as date_envoi,m.tel AS telephone');
        $this->db->from($this->table." as d");
        $this->db->join($this->table_membres.' as m', 'd.groupe=m.id_groupe','left');
        $this->db->join($this->table_type.' as t', 't.id=d.type','left');
        $this->db->join($this->table_stages.' as si', 'si.id_stagiare_el=m.id','left');
        $this->db->order_by('d.id', 'DESC');
        $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
        $query = $this->db->get(); 
        $ret['cnt'] = $query->num_rows();
        $i = 0 ;  
        foreach ($query->result() as $res) {
            $ret[$i]['id']   = $res->id;
            $ret[$i]['nom']     = $res->titre      ;
            $ret[$i]['proprietaire']        = $res->stagiaireNom.' '.$res->stagiairePrenom     ;
            $ret[$i]['fichier']= $res->fichier;
            $ret[$i]['commentaire']     = $res->comment;
            $ret[$i]['type']        = $res->type;
            $ret[$i]['type_id']     = $res->type_id;
            $ret[$i]['tuteur_statut']       = $res->tuteur_statut;
            $ret[$i]['prop']    = $res->prop    ;
            $ret[$i]['groupe']  = $res->groupe  ;
            $ret[$i]['date']    = $res->date   ;
            $ret[$i]['date_envoi']  = $res->date_envoi ;
            $ret[$i]['date_modif']  = $res->date_modif ;
            $ret[$i]['priv']    = $res->priv ;
            $ret[$i]['telephone']   = $res->telephone ;
            $ret[$i]['tuteur_affect']   = $res->tuteur_affect ;
            $ret[$i]['num_stage']   = $res->num_stage ;
            $ret[$i]['num_individu']    = $res->num_individu ;            
            $i++ ;
        }  
        return($ret);
            
    }
    
    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }
/*

    public function Nb($idg) {
        $this->db->select('id');
        $this->db->from($this->table);
        $this->db->where('groupe', $idg);
        $query = $this->db->get();         
        return ($query->num_rows());
    }*/

    public function getDocToSignById($idDoc) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id', $idDoc);
        return $this->db->get();     
    }

    public function Read($idg) {
        
        $this->db->select('d.id,u.prenom,u.nom,d.titre,d.comment,d.fichier,d.date,d.taille,d.nbcomment,d.groupe');
        $this->db->from($this->table." as d");
        $this->db->join($this->table_membres.' as u', 'd.prop=u.id','left');
        $this->db->where('d.id', $idg);
        $query = $this->db->get();         
        $result = $query->result()  ;        
        if (is_array($result)) {         
            foreach ($result as $res) {  

                $ret['user']    = $res->prenom." ".$res->nom;
                $ret['titre']   = $res->titre        ;
                $ret['comment'] = $res->comment      ;
                $ret['date']    = $res->date                    ;
                $ret['file']    = $res->fichier                 ;
                $ret['nb']      = $res->nbcomment               ;
                $ret['groupe']  = $res->groupe              ;
                return($ret) ;
            }
        }
        return(false);
    }

    /*public function InsertComment($idD,$comment) {
        $ret  = $this->Read($idD)   ;
        $date = getdate()                           ;
        $date = date(FORMATDATETIME ,$date["0"])        ;
        $m_nb = ($ret['nb']==""?"0":$ret['nb']+1)   ;
      
        $finalComment = "<DEB>".$this->Replace($this->session->userdata ( 'GUSER' ))." a écrit le ".$date."<MID>".$this->Replace($comment)."<FIN>".addslashes($this->Replace($ret['comment']));

        $infoComment = array('comment'=>$finalComment, 'nbcomment'=>$m_nb);
        $this->db->where('id', $idD);
        $this->db->update($this->table, $infoComment);

    }

    public function update($idD,$data) {
        $this->db->where('id', $idD);
        $this->db->update($this->table, $data);

    }

    public function add($additional_data = array()){

        $this->db->trans_start();
        $this->db->insert('document', $additional_data);       
        $id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $id;
    

    }

    public function Replace($txt) {
        $mytxt = trim($txt);
        return $mytxt ;
    }*/
    public function getStatus($statut_stagiaire,$statut_prof,$type_doc){
        switch ($type_doc){
            case 4:
                    if($statut_stagiaire == 0 && $statut_prof > 0){
                            $status = '<span class="signed nextstep">signé prof</span>';
                    }elseif($statut_stagiaire > 0 && $statut_prof > 0){
                            $status = '<span class="signed final">signé  prof/stag</span>';
                    }else{
                        $status = '<span class="notsigned">non signé</span>';
                    }
            break;

            case 5:

                if($statut_stagiaire > 0 && $statut_prof == 0){
                            $status = '<span class="signed nextstep">signé stagiaire</span>';
                    }elseif($statut_stagiaire > 0 && $statut_prof > 0){
                            $status = '<span class="signed final"> signé stag/prof    </span>';
                    }else{
                        $status = '<span class="notsigned">non signé</span>';
                    }
            
            break;

            case 6:

                if($statut_stagiaire){
                            $status = '<span class="signed final">signé stagiaire</span>';
                }else{
                        $status = '<span class="notsigned">non signé</span>';
                }
            break;

            default:
                    $status = '<span class="notsigned">non signé</span>';
            break;
        }
        //$status = "non signé";
        return $status;
    } 


}

?>
