<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Groupes_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->table_grp = 'groupe';
        $this->table     = 'list_groupe' ;
        $this->table_atelier_grp     = 'atelier_thematique_groupe' ;
        $this->table_atelier     = 'atelier_thematique' ;
        $this->load->model('utilities_model');        
        $this->load->model('sessions_model');        
        $this->load->model('tracking_model');        
        $this->load->model('log_model');        
    }


    public function readGrpTutor($idu) {
        $date = getdate() ;
        $date1 = $date[0];
        $this->db->select('m.nom,m.prenom, m.date_connexion, ls.description, m.id_groupe, m.id, m.extranet_id, max(s.date_cnx) as date_cnx, m.date_fin_acces');

        $this->db->from('membres as m');
        $this->db->join('list_societe as ls', 'ls.id_societe = m.id_societe','left');
        $this->db->join('groupe as groupe', 'groupe.id_membres=m.id','inner');
        $this->db->join('list_groupe as l', 'l.id_groupe=m.id_groupe','inner');
        $this->db->join('stat_connexion as s', 's.id_groupe=m.id_groupe','left');
        $this->db->where('l.id_tuteur', $idu);
        $this->db->where('m.date_fin_acces >', $date1);
        $this->db->where('m.mode_acces !=', '3');
        $this->db->where('m.type', 0);
        $this->db->group_by('m.id');
        $this->db->order_by('m.prenom,m.nom', 'desc');
        
        $query = $this->db->get(); 

        return $query->result();

    }

    public function deletegrp($id_groupe){
        $this->db->delete($this->table_grp, array('id_groupe' => $id_groupe));
    }

    public function deletelistgrp($id_groupe){
        $this->db->delete($this->table, array('id_groupe' => $id_groupe));
    }

    public function deleteByMember($id_membres){
        $this->db->delete($this->table_grp, array('id_membres' => $id_membres));
    }

    public function updategrp($id_groupe,$data) {
        $this->db->where('id_groupe', $id_groupe);
        $ret = $this->db->update($this->table_grp, $data);
        $this->db->affected_rows();
        return $ret;
    }
    public function updatelistgrp($id_groupe,$data) {
        $this->db->where('id_groupe', $id_groupe);
        $this->db->update($this->table, $data);
        $this->db->affected_rows();
    }

    public function addgrp($data) {     
        $this->db->trans_start();
        $this->db->insert($this->table_grp, $data);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();

    }
    public function addlistgrp($data) {     
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();

    }
    public function addlistgrpPr($sql) {     
        if ($this->db->simple_query($sql)) {
            return 'success';
        }
        else{
            $ret['error'] = $this->db->error();
            $ret['query'] = $this->db->last_query();
            return $ret;        
        }

    }

    public function delTuteur($idg,$idt) {
        $this->db->delete($this->table, array('id_groupe' => $idg,'id_tuteur' => $idt));
    }

    public function deleteListGroupesNotInParams($arrayIgGroupes,$trainer) {
        $this->db->where_not_in('id_groupe', $arrayIgGroupes);
        $this->db->where('id_tuteur', $trainer);
        $this->db->delete($this->table);
    }

    public function addTuteur($idg,$idt) {
        $data = array();
        $this->db->select('id_groupe');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idg);
        $this->db->where('id_tuteur', $idt);
        $query = $this->db->get(); 
        if ($query->num_rows() > 0) {
            return 0;
        }   
        else{
            $this->db->select('id_groupe,name,code,repertoire,planning,glossaireenligne');
            $this->db->from($this->table);
            $this->db->where('id_groupe', $idg);
            $this->db->limit(1);
            $query1 = $this->db->get();  
            if ($query1->num_rows() > 0) {   
                $result = $query1->result();
                $data = array();
                foreach ($result as $res){
                    $data = array(
                        'id_groupe' => $idg,
                        'name' => $res->name,
                        'code' => $res->code,
                        'id_tuteur' => $idt,
                        'repertoire' => $res->repertoire,
                        'glossaireenligne' => (count($this->checkGlossaireOnline($idg)) >= 1) ? 1 : $res->glossaireenligne,
                        'date_modif' => time(),
                        'planning' => $res->planning
                    );          
                }
            }
            else{
                $this->load->model('membres_model');    
                $data = array(
                    'id_groupe' => $idg,
                    'name' => $this->membres_model->RequestByGrp('nom', $idg).' '.$this->membres_model->RequestByGrp('prenom', $idg),
                    'code' => 'G'.$idg,
                    'id_tuteur' => $idt,
                    'repertoire' => 'GRP'.$idg,
                    'glossaireenligne' => 0,
                    'date_modif' => time(),
                    'planning' => ''
                );  
            } 


            if (isset($data) && is_array($data)) {
                $this->addlistgrp($data); 
            }
        }
        
    }


    public function checkGlossaireOnline($idg) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe ', $idg);
        $this->db->where('glossaireenligne', 1);
        $query = $this->db->get(); 
        return $query->result();
        
    }

    public function Atelier($idg) {
        $this->db->select('a.at_id as id,a.at_theme as name');
        $this->db->from($this->table_atelier_grp.' as ag');
        $this->db->join($this->table_atelier.' as a', 'ag.`at_id` = a.`at_id`','left');
        $this->db->where('ag.groupe_id', $idg);
        $this->db->order_by('m.nom', 'desc');
        $index = 0;
        $query = $this->db->get();   
        $ret['cnt'] = $query->num_rows();     
        $result = $query->result();
        if (is_array($result)) {
            foreach ($result as $res){
                $ret[$index]['name']    = $res->name;
                $ret[$index]['id']  = $res->id;
                $index++ ;             
            }
        }
        return($ret);
    }

    public function membres($idg) {
        $this->db->select('m.prenom,m.nom,m.id, from_unixtime(m.date_connexion),m.nbconnexion');
        $this->db->from('membres as m');
        $this->db->join('groupe as g', 'm.id = g.id_membres','left');
        $this->db->where('g.id_groupe', $idg);
        $this->db->order_by('m.nom', 'desc');
        $query = $this->db->get();        
        return $query->result();
    }

    public function Members($idg) {
        $this->db->select('m.id_groupe,m.prenom,m.nom,m.id, from_unixtime(m.date_connexion) as date_cnx,m.nbconnexion');
        $this->db->from('membres as m');
        $this->db->join('groupe as g', 'm.id = g.id_membres','left');
        $this->db->where('g.id_groupe', $idg);
        $this->db->order_by('m.nom', 'desc');
        $index = 0;
        $query = $this->db->get();   
        $ret['cnt'] = $query->num_rows();     
        $result = $query->result();
        if (is_array($result)) {
            foreach ($result as $res){
                $ret[$index]['name']    = $res->prenom.' '.$res->nom;
                $ret[$index]['prenom']  = $res->prenom;
                $ret[$index]['nom']     = $res->nom;
                $ret[$index]['id']      = $res->id;
                $ret[$index]['date_cnx']= $res->date_cnx;
                $ret[$index]['id_groupe']= $res->id_groupe;
                $ret[$index]['nbconnexion'] = $res->nbconnexion;
                $index++ ;             
            }
        }
        return($ret);
    }

    public function getTotalSessionTutoree($idu) {
        $this->db->select('count(*) as nb');

        $this->db->from('session_tutoree');
        $this->db->where('id_stagiaire', $idu);
        $query = $this->db->get();        
        return $query->result();
    }

    public function getRepertoireGrp($idgrp) {
        $this->db->select('repertoire');

        $this->db->from($this->table);
        $this->db->where('id_groupe', $idgrp);
        $query = $this->db->get();        
        return $query->result();
    }

    public function GetInfosTuteur($id_groupe,$id_tuteur) {
        $this->db->from($this->table);
        $this->db->where('id_groupe', $id_groupe);
        $this->db->where('id_tuteur', $id_tuteur);
        $query = $this->db->get();        
        return $query->result();
    }

    public function getAllByTrainneIdGroupId($id_membre,$idgrp) {
        $this->db->select('*');
        $this->db->from($this->table_grp);
        $this->db->where('id_groupe', $idgrp);
        $this->db->where('id_membres', $id_membre);
        $query = $this->db->get();        
        return $query->result();
    }

    public function getUserIdByGroupId($grpId) { 

        $this->db->select('m.id');
        $this->db->from('membres as m');
        $this->db->join('groupe as g', 'g.id_membres=m.id','left');
        $this->db->where('g.id_groupe ', $grpId);
        $this->db->group_by('m.id');
        $query = $this->db->get(); 
        $result = $query->result()  ;   
        if (is_array($result)) {
            foreach ($result as $res){
                return($res->id);               
            }
        }   
        
    }

    public function readListGroupe($idu, $all=true){       

        $ret = array();
        $this->db->select('g.id_groupe, l.name');
        $this->db->from('groupe as g');
        $this->db->join('list_groupe as l', 'l.id_groupe=g.id_groupe','left');
        $this->db->where('g.id_membres ', $idu);
        $this->db->order_by('l.name', 'asc');
        $this->db->group_by('l.name');
        $query = $this->db->get(); 
        $result = $query->result()  ;   
        if ( $all ) {
            $i = 0 ;
            $ret['cnt'] = $query->num_rows();
            foreach ($result as $res){
                $ret[$i]['id']  = $res->id_groupe;
                $ret[$i]['name']= $res->name;
                $i++ ;
            }
        } else {
            foreach ($result as $res){
                $ret[] = $res->id_groupe;
            }
        }  
        return($ret);
    }

    public function delMembre($id_groupe,$idm){

        $this->db->where('id_groupe', $id_groupe);
        $this->db->where('id_membres', $idm);
        $this->db->delete($this->table_grp);

        $this->db->where('id_groupe', $id_groupe);
        $this->db->delete($this->table);
    }

    public function supprimerStagiairePortefeuille($idTuteur,$idGroup){

        $this->db->where('id_groupe', $idGroup);
        $this->db->where('id_tuteur', $idTuteur);
        $this->db->delete($this->table);
    }

    public function delUserGroupe($idm,$idg) {
        $this->delMembre($idg,$idm);
        $ret = $this->sessions_model->read($idg);
        for($j=0;$j<$ret['cnt'];$j++) {
            $this->tracking_model->del($idm,$ret[$j]['sequence_id'],$idg);
            $this->log_model->del($idm,$idg);
        }
    }

    public function filtrer($key, $page, $segment) {
        $ret = array()      ;
        $this->db->select("name,id_groupe,code");
        $this->db->from($this->table);
        if ( $key != '') {
            $this->db->where('name LIKE', "%".$key."%");
        }

        if ($page != null && $segment != null) {
            $this->db->limit($page, $segment); 
        }
        $this->db->group_by('id_groupe');
        $this->db->order_by('name', 'asc');
        $query = $this->db->get(); 
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;   
        $i=0;
        foreach ($result as $res){
            $ret[$i]['name']    = $res->name ;
            $ret[$i]['id']      = $res->id_groupe ;
            $ret[$i]['code']    = $res->code ;
            $i++;
        }
       
        return($ret);
    }


    public function readCountfiltrer($key) {
      
        $ret = array()      ;
        $this->db->select("name,id_groupe,code");
        $this->db->from($this->table);
        if ( $key != '') {
            $this->db->where('name LIKE', "%".$key."%");
        }
        $this->db->order_by('name', 'asc');
        $query = $this->db->get(); 
        return $query->num_rows();
    }

    public function getListActivityByTuteur($idu) {
        
        $this->db->select('t.*,t.type AS tracking_type');
        $this->db->from('tracking as t');
        $this->db->where('t.user_id ', $idu);
        $this->db->order_by('t.date', 'desc');
        $query = $this->db->get(); 
        return $query->result()  ;  
    }
    public function getListActivity($idu, $date=true, $limit=false) {
        
        
        $this->db->select('FROM_UNIXTIME(t.date) as heure_commence ,SEC_TO_TIME(t.time) as complete, l.sequence_titre as sequence, s.titre as Exercice');
        
        $this->db->from('tracking as t');
        $this->db->join('membres as m', 't.user_id=m.id','inner');
        $this->db->join('sequence as s', 's.numero=t.chapitre_id AND s.id_sequence=t.sequence_id','inner');
        $this->db->join('list_sequence as l', 'l.sequence_id=t.sequence_id','inner');
        $this->db->where('t.user_id ', $idu);
        
        if ($date) {
            $this->db->where('t.date >= ', 'm.date_connexion');
        }
        $this->db->group_by('t.date,t.time,l.sequence_titre,s.titre');
        $this->db->order_by('t.date', 'desc');
        if ($limit) {
            $this->db->limit(3);
        }
        $i = 0          ;
        $ret = array()  ;
        $query = $this->db->get(); 
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;   
        if (is_array($result)) {
            foreach ($result as $res){
                $ret[$i]['date']    = $res->heure_commence ;
                if ($idu==7880) {
                    $ret[$i]['time']    = '';
                }
                else{
                    $ret[$i]['time']    = $res->complete ;
                }
                
                $ret[$i]['sequence']    = $res->sequence ;
                $ret[$i]['exercice']    = $res->Exercice ;
                $i++ ;             
            }
        } 

        return($ret);
    }

    /*public function readGroupStagiaire($id_membres='') {
      
        $ret = array()      ;
        $i = 0;
        $this->db->distinct();
        $this->db->select('g.id_groupe, l.name');
        $this->db->from('groupe as g');
        $this->db->join('list_groupe as l', 'l.id_groupe=g.id_groupe','inner'); 
        if(!empty($id_membres)) {
            $this->db->where('g.id_membres ', $id_membres);
        }
        $this->db->group_by('g.id_groupe', 'desc');    
        $query = $this->db->get(); 
        $result= $query->result();
        $ret['cnt'] = $query->num_rows();  
        if (is_array($result)) {
            foreach ($result as $res){
                $ret[$i]['name']         = $res->name;
                $ret[$i]['id']    = $res->id_groupe;
                $i++ ;
            }
        }   
        
        return($ret);

    }*/
    public function readGroupStagiaire($idu=0) {
        $i = 0 ;
        $date = getdate() ;
        $this->db->select('m.id,m.nom,m.prenom, m.id_groupe, m.extranet_id');
        $this->db->from('membres as m');
        $this->db->join('groupe as groupe', 'groupe.id_membres=m.id','inner');
        $this->db->join('list_groupe as l', 'l.id_groupe=m.id_groupe','inner');
        $this->db->where('m.date_fin_acces >', $date['0']);
        $this->db->where('m.mode_acces !=', '3');
        if($idu != 0) {
            $this->db->where('l.id_tuteur', $idu);
        }
        $this->db->group_by('m.id');
        $this->db->order_by('m.prenom,m.nom', 'asc');
        $query = $this->db->get(); 
        $result= $query->result();
        $ret['cnt'] = $query->num_rows();  
        if (is_array($result)) {
            foreach ($result as $res){
                $ret[$i]['name']         = $res->prenom.' '.$res->nom;
                $ret[$i]['id']           = $res->id;
                $ret[$i]['extranet_id']  = $res->extranet_id;
                $ret[$i]['id_groupe']    = $res->id_groupe;
                $i++ ;
            }
        }   
        
        return($ret);
    }

    public function checkGlossaireEnligne($idg) {
        $this->db->select('glossaireenligne');
        $this->db->from($this->table);
        $this->db->where('id_groupe ', $idg);
        $this->db->limit(1);
        $query = $this->db->get(); 
        $result= $query->result();
        if (is_array($result)) {
            foreach ($result as $res){
                return $res->glossaireenligne;
            }
        }
    }

    public function readGroupe($idg) {
        $this->db->select('id_groupe, name,code,glossaireenligne');
        $this->db->from($this->table);
        $this->db->where('id_groupe ', $idg);
        $query = $this->db->get(); 
        $result= $query->result();
        $ret['cnt'] = $query->num_rows();  
        if (is_array($result)) {
            foreach ($result as $res){
                $ret['name']         = $res->name;
                $ret['id']    = $res->id_groupe;
                $ret['code']    = $res->code;
                $ret['glossaireenligne']    = $res->glossaireenligne;
            }
        }   
        return($ret);
    }


    public function readAllTuteurInGroupe($idg) {
        $this->db->select('id_tuteur');
        $this->db->from($this->table);
        $this->db->where('id_groupe ', $idg);
        $this->db->where('id_tuteur !=', 0);
        $query = $this->db->get(); 
        return $query->result();
        
    }

    public function readPrototypeGroupe($idg) {
        $this->db->select('*');
        $this->db->from($this->table_grp);
        $this->db->where('id_groupe ', $idg);
        $query = $this->db->get(); 
        $result= $query->result();
        $ret['cnt'] = $query->num_rows();  
        if (is_array($result)) {
            foreach ($result as $res){
                $ret['prototype']                                = $res->prototype;
                $ret['allowed_commande_papers_glossary']         = $res->allowed_commande_papers_glossary;
            }
        }   
        return($ret);
    }

    public function Directory($idg) {
        $this->db->select('repertoire');
        $this->db->from($this->table);
        $this->db->where('id_groupe ', $idg);
        $query = $this->db->get(); 
        $result = $query->result()  ;   
        if (is_array($result)) {
            foreach ($result as $res){
                return $res->repertoire;               
            }
        }   
    }


    public function Name($idg) {
        $this->db->select('name');
        $this->db->from($this->table);
        $this->db->where('id_groupe ', $idg);
        $query = $this->db->get(); 
        $result = $query->result()  ;   
        if (is_array($result)) {
            foreach ($result as $res){
                return $res->name;               
            }
        }
        else{
            return('*******');
        }
    }

    public function Request($field,$id_groupe) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id_groupe', $id_groupe);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function getALLTutor($id_groupe) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $id_groupe);
        $this->db->where('id_tuteur > ', 0);
        $query = $this->db->get();
        return $query->result();
    }

    public function RequestByGrp($field,$id_groupe) {
        $this->db->select($field);
        $this->db->from($this->table_grp);
        $this->db->where('id_groupe', $id_groupe);
        $query = $this->db->get();
        $result = $query->result();
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                return $res->$field ;
            }
        }       
    }


    public function RequestByGrpLimit1($field,$id_groupe) {
        $this->db->select($field);
        $this->db->from($this->table_grp);
        $this->db->where('id_groupe', $id_groupe);
        $this->db->limit(1);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function getByProfessorIdAndGroupId($professorId,$id_groupe) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_tuteur ', $professorId);
        $this->db->where('id_groupe ', $id_groupe);
        $query = $this->db->get(); 
        return $query->result();
    }

    public function getAllProfessorByGroup($id_groupe) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe ', $id_groupe);
        $this->db->where('id_tuteur !=', 0);
        $this->db->group_by('id_tuteur');
        $query = $this->db->get(); 
        return $query->result();
    }

    public function getMaxIdGroupes(){
        $maxIdGroupe = 0;
        $this->db->select('MAX(id_groupe) AS maxIdGroupe');
        $this->db->from($this->table);
        $query = $this->db->get(); 
        foreach ($query->result() as $res) {
            $maxIdGroupe = $res->maxIdGroupe;
        }
        return $maxIdGroupe;
    }

    public function RequestByParams($arrayData){
        $this->db->select('*');
        $this->db->from($this->table);
        if (isset($arrayData['id_tuteur'])) {
            $this->db->where('id_tuteur', $arrayData['id_tuteur']);
        }

        if (isset($arrayData['id_groupe'])) {
            $this->db->where('id_groupe', $arrayData['id_groupe']);
        }

        if (isset($arrayData['name'])) {
            $this->db->where('name', $arrayData['name']);
        }

        if (isset($arrayData['repertoire'])) {
            $this->db->where('repertoire', $arrayData['repertoire']);
        }

        if (isset($arrayData['code'])) {
            $this->db->where('code', $arrayData['code']);
        }

        if (isset($arrayData['glossaireenligne'])) {
            $this->db->where('glossaireenligne', $arrayData['glossaireenligne']);
        }

        $query = $this->db->get(); 
        return $query->result();
    }


}

?>
