<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Tracking_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->load->model('connexion_model');  
        $this->load->model('coursHistorik_model'); 
        $this->load->model('todolist_model'); 
        $this->load->model('document_model'); 
        $this->load->model('newsletter_model'); 
        $this->load->model('modules_model'); 
        $this->load->model('sequence_model'); 
        $this->load->model('classificationFavoris_Model'); 
        $this->load->model('stat_prg_model'); 
        $this->load->model('classificationFavoris_Model'); 
        $this->load->model('classificationFavoris_Model'); 
        $this->table = 'tracking';        
        $this->table_seq = 'sequence';        
        $this->table_list_seq = 'list_sequence';        
        $this->table_membres = 'membres';        
        $this->table_connexion = 'connexion';        
    }

    public function getAllByDateTimeAndType($dateTime,$type){
      $this->db->select('t.*, CONCAT(m.prenom, " ", m.nom) AS nomination,TIME(FROM_UNIXTIME(t.date)) AS timeCnx');
      $this->db->from($this->table.' AS t');
      $this->db->join($this->table_membres.' AS m ', 'm.id = t.user_id', 'INNER');
      $this->db->join($this->table_connexion.' AS c ', 'c.id_user = t.user_id', 'INNER');
      $this->db->where('t.date >=', $dateTime);
      $this->db->where('m.type', $type);
      $this->db->group_by(array("t.user_id", "t.id_cnx"));
      $this->db->order_by('t.id_tracking', 'DESC');
      $query = $this->db->get();        
      return $query->result();
    }

    public function getInfosTrackingUser($dateTime,$userId){
      $this->db->select('t.*, CONCAT(m.prenom, " ", m.nom) AS nomination,TIME(FROM_UNIXTIME(t.date)) AS timeCnx');
      $this->db->from($this->table.' AS t');
      $this->db->join($this->table_membres.' AS m ', 'm.id = t.user_id', 'INNER');
      $this->db->join($this->table_connexion.' AS c ', 'c.id_user = t.user_id', 'INNER');
      $this->db->where('t.user_id', $userId);
      $this->db->where('t.date >=', $dateTime);
      $this->db->group_by(array("t.user_id", "t.id_cnx"));
      $this->db->order_by('t.id_tracking', 'DESC');
      $this->db->limit(1);
      $query = $this->db->get();        
      return $query->result();
    }

    public function getCountByDureeCours($dateDebutCoursUnixTime,$dateFinCoursUnixTime){
      $this->db->select('COUNT(id_tracking) AS nbTracking');
      $this->db->from($this->table);
      $this->db->where('date >=', $dateDebutCoursUnixTime);
      $this->db->where('date <=', $dateFinCoursUnixTime);
      $query = $this->db->get();        
      $result =  $query->result();
      foreach ($result as $res){
          $nbTracking = $res->nbTracking;
         
      }
      return $nbTracking;
    }

    public function AddTuteur($sequence_id,$chapitre_id,$type){
        $date = getdate();      
        $date = $date["0"];
        $trackinginfo = array(
            'user_id'       =>$this->session->userdata ('GUSERID'), 
            "sequence_id"   => $sequence_id, 
            "chapitre_id"   => $chapitre_id, 
            "date"          => $date, 
            "date_logout"   => $date, 
            'time'          => 0, 
            'score  '       => 100, 
            'max_score  '   => 0, 
            'status'        => 2, 
            'comment'       => '', 
            'loc'           => 1, 
            'detail'        => 0, 
            'type'          => $type, 
            'id_cnx'        => $this->session->userdata ('CNX')
        );

        //Create a new tracking in db
        $this->db->trans_start();
        $this->db->insert($this->table, $trackinginfo);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();

        return $id;


    }
    public function Add($sequence_id,$chapitre_id,$type,$module_id=''){
        $date = getdate();      
        $date = $date["0"];
        $groupe;
        if ($this->session->userdata ('STAGIAIREGRP') != '') {  
            $groupe = $this->session->userdata ('STAGIAIREGRP');
        }
        else{
            $groupe = $this->session->userdata ('GROUPE');
        }
        $trackinginfo = array(
            'user_id'       =>$this->session->userdata ('GUSERID'), 
            'groupe_id'     => $groupe, 
            "module_id"     => $module_id != '' ? $module_id : NULL, 
            "sequence_id"   => $sequence_id, 
            "chapitre_id"   => $chapitre_id, 
            "date"          => $date, 
            "date_logout"   => $date, 
            'time'          => 0, 
            'score  '       => 100, 
            'max_score  '   => 0, 
            'status'        => 2, 
            'comment'       => '', 
            'loc'           => 1, 
            'detail'        => 0, 
            'type'          => $type, 
            'id_cnx'        => $this->session->userdata ('CNX')
        );

        //Create a new tracking in db
        $this->db->trans_start();
        $this->db->insert($this->table, $trackinginfo);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();

        return $id;
    }

    public function AddBtnLateral($sequence_id,$chapitre_id,$type,$statusShortcuts){
        $date = getdate();      
        $date = $date["0"];
        $groupe;
        if ($this->session->userdata ('STAGIAIREGRP') != '') {  
            $groupe = $this->session->userdata ('STAGIAIREGRP');
        }
        else{
            $groupe = $this->session->userdata ('GROUPE');
        }
        $trackinginfo = array(
            'user_id'       =>$this->session->userdata ('GUSERID'), 
            'groupe_id'     => $groupe, 
            "module_id"     => NULL, 
            "sequence_id"   => $sequence_id, 
            "chapitre_id"   => $chapitre_id, 
            "date"          => $date, 
            "date_logout"   => $date, 
            'time'          => 0, 
            'score  '       => 100, 
            'max_score  '   => 0, 
            'status'        => 2, 
            'comment'       => '', 
            'loc'           => 1, 
            'detail'        => 0, 
            'type'          => $type, 
            'id_cnx'        => $this->session->userdata ('CNX')
        );

        if ($statusShortcuts == true) {
          //Create a new tracking in db
          $this->db->trans_start();
          $this->db->insert($this->table, $trackinginfo);        
          $id = $this->db->insert_id();        
          $this->db->trans_complete();
        }
        else{
          $id = '';
        }

        return $id;
    }

    /*public function addCurrentConnexion($sequence_id,$chapitre_id,$type){
        $activite;
        switch ($type) {
          case 2:
            if (!is_null($sequence_id) && is_null($chapitre_id)) {
              $activite       = $this->coursHistorik_model->Request('intitule',$sequence_id);
            }
            else {
              $activite       = $this->todolist_model->Request('sequence',$chapitre_id);
            }
            break;
          case 4:
            if (!is_null($sequence_id)) {
              $activite       = $this->document_model->Request('titre',$sequence_id);
            }
            break;
          case 6:
            if (!is_null($chapitre_id)) {    
              $activite       = 'Article of newsletter : '.$this->newsletter_model->Request('article',$chapitre_id);
            }
            if ($chapitre_id == 0 && !is_null($sequence_id) && $sequence_id != 10086) { 
              switch ($sequence_id) {
                case 1:
                  $Module       = 'Politics';
                  break;
                case 2:
                  $Module       = 'Health';
                  break;
                case 3:
                  $Module       = 'Art';
                  break;
                case 4:
                  $Module       = 'Travel';
                  break;
                case 5:
                  $Module       = 'Lifestyle';
                  break;
                case 6:
                  $Module       = 'Livestock';
                  break;
                case 7:
                  $Module       = 'Culture';
                  break;
                case 8:
                  $Module       = 'Society';
                  break;
                case 9:
                  $Module       = 'Sport';
                  break;                        
                case 9:
                  $Module       = 'Economy';
                  break;
                default:
                  # code...
                  break;
              }
              $activite       = 'Theme of newsletter : '.$Module;
            }
            break;
          case 7:
            $Parcours       = '';
            $Menu           = 'My educational library';                    
            $SousMenu       = 'Pedagogical training';                    
            if (!is_null($res->module_id)) {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
            } 

            if (is_null($res->module_id) && !is_null($sequence_id)) {
              $Module         = 'Complementary Activities';
            }

            if (!is_null($sequence_id) && $sequence_id != 0) {
              $Sequence       = $this->sequence_model->Request('sequence_titre',$sequence_id);
            }   

            if (!is_null($chapitre_id) && $chapitre_id != 0) {    
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$sequence_id,$chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$sequence_id,$chapitre_id);
            }
            break; 
          case 8:
            $Parcours       = '';
            $Menu           = 'My educational library';                    
            $SousMenu       = 'Personal Interest';                    
            if (!is_null($res->module_id)) {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
            } 

            if (is_null($res->module_id) && !is_null($sequence_id)) {
              $Module         = 'Complementary Activities';
            }

            if (!is_null($sequence_id) && $sequence_id != 0) {
              $Sequence       = $this->sequence_model->Request('sequence_titre',$sequence_id);
            }   

            if (!is_null($chapitre_id) && $chapitre_id != 0) {     
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$sequence_id,$chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$sequence_id,$chapitre_id);
            }
            break; 
          case 9:
            $Parcours       = '';
            $Menu           = 'My educational library';                    
            $SousMenu       = 'Linguistic Tools';                    
            if (!is_null($res->module_id)) {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
            } 

            if (is_null($res->module_id) && !is_null($sequence_id)) {
              $Module         = 'Complementary Activities';
            }

            if (!is_null($sequence_id) && $sequence_id != 0) {
              $Sequence       = $this->sequence_model->Request('sequence_titre',$sequence_id);
            }   

            if (!is_null($chapitre_id) && $chapitre_id != 0) {     
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$sequence_id,$chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$sequence_id,$chapitre_id);
            }
            break; 
          case 10:
            $Parcours       = '';
            $Menu           = 'Profil data';                    
            $SousMenu       = 'Statistic connexion'; 
            break;
          case 14:
            $Parcours       = '';
            $Menu           = 'Training objectif'; 
            break; 
          case 16:
            $Parcours       = 'Outils et document de mon stage';
            $Menu           = 'My document to sign'; 
            break;  
          case 18:
            //$Parcours       = 'Dashbord';  
            $Parcours       = '';  
            break;       
          case 20:
            $Parcours       = '';
            $Menu           = 'My own expression databank'; 
            break;     
          case 22:
            $Parcours       = '';
            $Menu           = 'My glossary';
            break;       
          case 23:
            $Parcours       = '';
            $Menu           = 'My audio';
            break;         
          case 24:
            $Parcours       = '';
            $Menu           = 'My training period';
            $SousMenu       = 'My favoris';  
            if ($this->stat_prg_model->Request('type',$sequence_id) == 'document') {
              $Module         = $this->classificationFavoris_Model->Request('intitule',$res->module_id);
              $Exercice       = $this->document_model->Request('titre',$chapitre_id);
              $Lien           = $this->document_model->Request('fichier',$chapitre_id);
            }  
            elseif ($this->stat_prg_model->Request('type',$sequence_id) == 'activity_sequence') {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
              $Sequence       = $this->sequence_model->Request('sequence_titre',$this->stat_prg_model->Request('id_prg',$sequence_id));
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$this->stat_prg_model->Request('id_prg',$sequence_id),$chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$this->stat_prg_model->Request('id_prg',$sequence_id),$chapitre_id);
            } 
            elseif ($this->stat_prg_model->Request('type',$sequence_id) == 'nl_article') {
              $Module         = $this->newsletter_model->Request('theme',$chapitre_id); 
              $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$chapitre_id));
              $Exercice       = $this->newsletter_model->Request('article',$chapitre_id);
              $Lien           = $this->newsletter_model->Request('origine',$chapitre_id);
            } 
            elseif ($this->stat_prg_model->Request('type',$sequence_id) == 'nl_categories') {
              $Module       = $this->stat_prg_model->Request('intitule',$sequence_id);
              if (!is_null($chapitre_id) && $chapitre_id != 0) {
                $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$chapitre_id));
                $Exercice       = $this->newsletter_model->Request('article',$chapitre_id);
                $Lien           = $this->newsletter_model->Request('origine',$chapitre_id);
              }
            }
            elseif ($this->stat_prg_model->Request('type',$sequence_id) == 'sequence_activite') {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
              $Sequence       = $this->sequence_model->Request('sequence_titre',$this->stat_prg_model->Request('id_prg',$sequence_id));
              if (!is_null($chapitre_id) && $chapitre_id != 0) {
                $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$this->stat_prg_model->Request('id_prg',$sequence_id),$chapitre_id);
                $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$this->stat_prg_model->Request('id_prg',$sequence_id),$chapitre_id);
              }
            }  
            else {
              $Module         = $this->classificationFavoris_Model->Request('intitule',$res->module_id);
              $Exercice       = $this->document_model->Request('titre',$chapitre_id);
              $Lien           = $this->document_model->Request('fichier',$chapitre_id);
            } 
            break;      
          case 25:
            $Parcours       = '';
            $Menu           = 'My educational tools';
            $SousMenu       = 'My connexion speed';  
            break;           
          case 26:
            $Parcours       = '';
            $Menu           = 'My educational tools';
            $SousMenu       = 'White paper';              
          case 30:
            $Parcours       = '';
            $Menu           = 'My educational tools';
            $SousMenu       = 'Conference call';   
            break;                
          default:
            # code...
            break;
        }
    }*/

    public function getLastActivityByCnx($cnx){
      $this->db->select('*');
      $this->db->from($this->table);
      $this->db->where('id_cnx', $cnx);
      $this->db->order_by('id_tracking', 'desc');
      $this->db->limit(1);
      $query = $this->db->get();        
      return $this->getAllActivity($query->result());
    }
    public function getMAxLastActivity($idStagiaireEl){
      $this->db->select('*');
      $this->db->from($this->table);
      $this->db->where('user_id', $idStagiaireEl);
      $this->db->order_by('id_tracking', 'desc');
      $this->db->limit(1);
      $query = $this->db->get();        
      return $this->getAllActivity($query->result());
    }

    public function getMAxLastActivityByCnx($idCnx){
      $this->db->select('*');
      $this->db->from($this->table);
      $this->db->where('id_cnx', $idCnx);
      $this->db->order_by('id_tracking', 'desc');
      $this->db->limit(1);
      $query = $this->db->get();        
      return $this->getAllActivity($query->result());
    }

    public function returnMAxLastActivityByCnx($idCnx){
      $this->db->select('*');
      $this->db->from($this->table);
      $this->db->where('id_cnx', $idCnx);
      $this->db->order_by('id_tracking', 'desc');
      $this->db->limit(1);
      $query = $this->db->get();        
      return $this->returnAllActivity($query->result());
    }



    public function returnAllActivity($result){
      $Parcours       = '';
      $Menu           = '';
      $SousMenu       = '';
      $Module         = '';
      $Sequence       = '';
      $Exercice       = '';
      $Lien           = '';
      $return         = '';
      foreach ($result as $res) {
        switch ($res->type) {
          case 2:
            //$Parcours       = 'Accès plateforme e-learning et tutorat';
            $Parcours       = '';
            $Menu           = 'My training period';
            $SousMenu       = 'Course history';
            if (!is_null($res->sequence_id)) {
              $Sequence       = $this->coursHistorik_model->Request('intitule',$res->sequence_id);
            }
            if (!is_null($res->chapitre_id)) {
              $Exercice       = $this->todolist_model->Request('sequence',$res->chapitre_id);
              $Lien           = $this->todolist_model->Request('url',$res->chapitre_id);
            }
            break;
          case 4:
            $Parcours       = '';
            $Menu           = 'My educational library';
            $SousMenu       = 'My database documents';
            if (!is_null($res->sequence_id)) {
              $Exercice       = $this->document_model->Request('titre',$res->sequence_id);
              $Lien           = $this->document_model->Request('fichier',$res->sequence_id);
            }
            break;
          case 6:
            $Parcours       = '';
            $Menu           = 'My educational library';
            $SousMenu       = 'Newsletter';
            if (!is_null($res->chapitre_id)) {    
              $Module         = $this->newsletter_model->Request('theme',$res->chapitre_id); 
              $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$res->chapitre_id));
              $Exercice       = $this->newsletter_model->Request('article',$res->chapitre_id);
              $Lien           = $this->newsletter_model->Request('origine',$res->chapitre_id);
            }
            if ($res->chapitre_id == 0 && !is_null($res->sequence_id) && $res->sequence_id != 10086) { 
              switch ($res->sequence_id) {
                case 1:
                  $Module       = 'Politics';
                  break;
                case 2:
                  $Module       = 'Health';
                  break;
                case 3:
                  $Module       = 'Art';
                  break;
                case 4:
                  $Module       = 'Travel';
                  break;
                case 5:
                  $Module       = 'Lifestyle';
                  break;
                case 6:
                  $Module       = 'Livestock';
                  break;
                case 7:
                  $Module       = 'Culture';
                  break;
                case 8:
                  $Module       = 'Society';
                  break;
                case 9:
                  $Module       = 'Sport';
                  break;                        
                case 9:
                  $Module       = 'Economy';
                  break;
                default:
                  # code...
                  break;
              }
            }
            break;
          case 7:
            $Parcours       = '';
            $Menu           = 'My educational library';                    
            $SousMenu       = 'Pedagogical training';                    
            if (!is_null($res->module_id)) {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
            } 

            if (is_null($res->module_id) && !is_null($res->sequence_id)) {
              $Module         = 'Complementary Activities';
            }

            if (!is_null($res->sequence_id) && $res->sequence_id != 0) {
              $Sequence       = $this->sequence_model->Request('sequence_titre',$res->sequence_id);
            }   

            if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {    
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$res->sequence_id,$res->chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$res->sequence_id,$res->chapitre_id);
            }
            break; 
          case 8:
            $Parcours       = '';
            $Menu           = 'My educational library';                    
            $SousMenu       = 'Personal Interest';                    
            if (!is_null($res->module_id)) {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
            } 

            if (is_null($res->module_id) && !is_null($res->sequence_id)) {
              $Module         = 'Complementary Activities';
            }

            if (!is_null($res->sequence_id) && $res->sequence_id != 0) {
              $Sequence       = $this->sequence_model->Request('sequence_titre',$res->sequence_id);
            }   

            if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {     
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$res->sequence_id,$res->chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$res->sequence_id,$res->chapitre_id);
            }
            break; 
          case 9:
            $Parcours       = '';
            $Menu           = 'My educational library';                    
            $SousMenu       = 'Linguistic Tools';                    
            if (!is_null($res->module_id)) {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
            } 

            if (is_null($res->module_id) && !is_null($res->sequence_id)) {
              $Module         = 'Complementary Activities';
            }

            if (!is_null($res->sequence_id) && $res->sequence_id != 0) {
              $Sequence       = $this->sequence_model->Request('sequence_titre',$res->sequence_id);
            }   

            if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {     
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$res->sequence_id,$res->chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$res->sequence_id,$res->chapitre_id);
            }
            break; 
          case 10:
            $Parcours       = '';
            $Menu           = 'Profil data';                    
            $SousMenu       = 'Statistic connexion'; 
            break;
          case 14:
            $Parcours       = '';
            $Menu           = 'Training period'; 
            $SousMenu       = 'Training objectif'; 
            break; 
          case 16:
            $Parcours       = 'Outils et document de mon stage';
            $Menu           = 'My document to sign'; 
            break;  
          case 18:
            //$Parcours       = 'Dashbord';  
            $Parcours       = '';  
            break;       
          case 20:
            $Parcours       = '';
            $Menu           = 'Premium menu'; 
            $SousMenu       = 'My own expression databank'; 
            break;     
          case 22:
            $Parcours       = '';
            $Menu           = 'Premium menu'; 
            $SousMenu       = 'My glossary';
            break;       
          case 23:
            $Parcours       = '';
            $Menu           = 'Premium menu'; 
            $SousMenu       = 'My audio';
            break;         
          case 24:
            $Parcours       = '';
            $Menu           = 'My training period';
            $SousMenu       = 'My favoris';  
            if ($this->stat_prg_model->Request('type',$res->sequence_id) == 'document') {
              $Module         = $this->classificationFavoris_Model->Request('intitule',$res->module_id);
              $Exercice       = $this->document_model->Request('titre',$res->chapitre_id);
              $Lien           = $this->document_model->Request('fichier',$res->chapitre_id);
            }  
            elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'activity_sequence') {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
              $Sequence       = $this->sequence_model->Request('sequence_titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id));
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id),$res->chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$this->stat_prg_model->Request('id_prg',$res->sequence_id),$res->chapitre_id);
            } 
            elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'nl_article') {
              $Module         = $this->newsletter_model->Request('theme',$res->chapitre_id); 
              $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$res->chapitre_id));
              $Exercice       = $this->newsletter_model->Request('article',$res->chapitre_id);
              $Lien           = $this->newsletter_model->Request('origine',$res->chapitre_id);
            } 
            elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'nl_categories') {
              $Module       = $this->stat_prg_model->Request('intitule',$res->sequence_id);
              if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {
                $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$res->chapitre_id));
                $Exercice       = $this->newsletter_model->Request('article',$res->chapitre_id);
                $Lien           = $this->newsletter_model->Request('origine',$res->chapitre_id);
              }
            }
            elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'sequence_activite') {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
              $Sequence       = $this->sequence_model->Request('sequence_titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id));
              if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {
                $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id),$res->chapitre_id);
                $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$this->stat_prg_model->Request('id_prg',$res->sequence_id),$res->chapitre_id);
              }
            }  
            else {
              $Module         = $this->classificationFavoris_Model->Request('intitule',$res->module_id);
              $Exercice       = $this->document_model->Request('titre',$res->chapitre_id);
              $Lien           = $this->document_model->Request('fichier',$res->chapitre_id);
            } 
            break;      
          case 25:
            $Parcours       = '';
            $Menu           = 'My educational tools';
            $SousMenu       = 'My connexion speed';  
            break;           
          case 26:
            $Parcours       = '';
            $Menu           = 'My educational tools';
            $SousMenu       = 'White paper'; 
            break;              
          case 30:
            $Parcours       = '';
            $Menu           = 'My educational tools';
            $SousMenu       = 'Conference call';   
            break;                 
          case 8888:
            $Parcours       = '';
            $Menu           = 'My training period';
            $SousMenu       = 'My profil';   
            break;                
          default:
            # code...
            break;
        }
      }
      $images_quotes = '<img src="assets/icons-f2+/historique_de_cours/ico-arrowright.png" alt="User elearning" class="user-image img-home icons-rigth">';

      /*if ($Parcours != '') {
        $return .= $Parcours;
      }*/
      if ($Menu != '') {
        //$return .= $images_quotes.$Menu;
        $return .= $Menu;
      }
      if ($SousMenu != '') {
        $return .= $images_quotes.$SousMenu;
      }
      if ($Module != '') {
        $return .= $images_quotes.$Module;
      }
      if ($Sequence != '') {
        $return .= $images_quotes.$Sequence;
      }
      if ($Exercice != '') {
        $return .= $images_quotes.$Exercice;
      }
      if ($Lien != '') {
        $return .= $images_quotes.$Lien;
      }

      return $return;
    }

    public function getAllActivity($result){
      $Parcours       = '';
      $Menu           = '';
      $SousMenu       = '';
      $Module         = '';
      $Sequence       = '';
      $Exercice       = '';
      $Lien           = '';
      $return         = '';
      foreach ($result as $res) {
        switch ($res->type) {
          case 2:
            $Parcours       = '';
            $Menu           = 'My training period';
            $SousMenu       = 'Course history';
            if (!is_null($res->sequence_id)) {
              $Sequence       = $this->coursHistorik_model->Request('intitule',$res->sequence_id);
            }
            if (!is_null($res->chapitre_id)) {
              $Exercice       = $this->todolist_model->Request('sequence',$res->chapitre_id);
              $Lien           = $this->todolist_model->Request('url',$res->chapitre_id);
            }
            break;
          case 4:
            $Parcours       = '';
            $Menu           = 'My educational library';
            $SousMenu       = 'My database documents';
            if (!is_null($res->sequence_id)) {
              $Exercice       = $this->document_model->Request('titre',$res->sequence_id);
              $Lien           = $this->document_model->Request('fichier',$res->sequence_id);
            }
            break;
          case 6:
            $Parcours       = '';
            $Menu           = 'My educational library';
            $SousMenu       = 'Newsletter';
            if (!is_null($res->chapitre_id)) {    
              $Module         = $this->newsletter_model->Request('theme',$res->chapitre_id); 
              $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$res->chapitre_id));
              $Exercice       = $this->newsletter_model->Request('article',$res->chapitre_id);
              $Lien           = $this->newsletter_model->Request('origine',$res->chapitre_id);
            }
            if ($res->chapitre_id == 0 && !is_null($res->sequence_id) && $res->sequence_id != 10086) { 
              switch ($res->sequence_id) {
                case 1:
                  $Module       = 'Politics';
                  break;
                case 2:
                  $Module       = 'Health';
                  break;
                case 3:
                  $Module       = 'Art';
                  break;
                case 4:
                  $Module       = 'Travel';
                  break;
                case 5:
                  $Module       = 'Lifestyle';
                  break;
                case 6:
                  $Module       = 'Livestock';
                  break;
                case 7:
                  $Module       = 'Culture';
                  break;
                case 8:
                  $Module       = 'Society';
                  break;
                case 9:
                  $Module       = 'Sport';
                  break;                        
                case 9:
                  $Module       = 'Economy';
                  break;
                default:
                  # code...
                  break;
              }
            }
            break;
          case 7:
            $Parcours       = '';
            $Menu           = 'My educational library';                    
            $SousMenu       = 'Pedagogical training';                    
            if (!is_null($res->module_id)) {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
            } 

            if (is_null($res->module_id) && !is_null($res->sequence_id)) {
              $Module         = 'Complementary Activities';
            }

            if (!is_null($res->sequence_id) && $res->sequence_id != 0) {
              $Sequence       = $this->sequence_model->Request('sequence_titre',$res->sequence_id);
            }   

            if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {    
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$res->sequence_id,$res->chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$res->sequence_id,$res->chapitre_id);
            }
            break; 
          case 8:
            $Parcours       = '';
            $Menu           = 'My educational library';                    
            $SousMenu       = 'Personal Interest';                    
            if (!is_null($res->module_id)) {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
            } 

            if (is_null($res->module_id) && !is_null($res->sequence_id)) {
              $Module         = 'Complementary Activities';
            }

            if (!is_null($res->sequence_id) && $res->sequence_id != 0) {
              $Sequence       = $this->sequence_model->Request('sequence_titre',$res->sequence_id);
            }   

            if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {     
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$res->sequence_id,$res->chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$res->sequence_id,$res->chapitre_id);
            }
            break; 
          case 9:
            $Parcours       = '';
            $Menu           = 'My educational library';                    
            $SousMenu       = 'Linguistic Tools';                    
            if (!is_null($res->module_id)) {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
            } 

            if (is_null($res->module_id) && !is_null($res->sequence_id)) {
              $Module         = 'Complementary Activities';
            }

            if (!is_null($res->sequence_id) && $res->sequence_id != 0) {
              $Sequence       = $this->sequence_model->Request('sequence_titre',$res->sequence_id);
            }   

            if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {     
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$res->sequence_id,$res->chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$res->sequence_id,$res->chapitre_id);
            }
            break; 
          case 10:
            $Parcours       = '';
            $Menu           = 'Profil data';                    
            $SousMenu       = 'Statistic connexion'; 
            break;
          case 14:
            $Parcours       = '';
            $Menu           = 'Training period'; 
            $SousMenu       = 'Training objectif'; 
            break; 
          case 16:
            $Parcours       = 'Outils et document de mon stage';
            $Menu           = 'My document to sign'; 
            break;  
          case 18:
            //$Parcours       = 'Dashbord';  
            $Parcours       = '';  
            break;       
          case 20:
            $Parcours       = '';
            $Menu           = 'Premium menu'; 
            $SousMenu       = 'My own expression databank'; 
            break;     
          case 22:
            $Parcours       = '';
            $Menu           = 'Premium menu'; 
            $SousMenu       = 'My glossary';
            break;       
          case 23:
            $Parcours       = '';
            $Menu           = 'Premium menu'; 
            $SousMenu       = 'My audio';
            break;         
          case 24:
            $Parcours       = '';
            $Menu           = 'My training period';
            $SousMenu       = 'My favoris';  
            if ($this->stat_prg_model->Request('type',$res->sequence_id) == 'document') {
              $Module         = $this->classificationFavoris_Model->Request('intitule',$res->module_id);
              $Exercice       = $this->document_model->Request('titre',$res->chapitre_id);
              $Lien           = $this->document_model->Request('fichier',$res->chapitre_id);
            }  
            elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'activity_sequence') {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
              $Sequence       = $this->sequence_model->Request('sequence_titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id));
              $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id),$res->chapitre_id);
              $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$this->stat_prg_model->Request('id_prg',$res->sequence_id),$res->chapitre_id);
            } 
            elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'nl_article') {
              $Module         = $this->newsletter_model->Request('theme',$res->chapitre_id); 
              $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$res->chapitre_id));
              $Exercice       = $this->newsletter_model->Request('article',$res->chapitre_id);
              $Lien           = $this->newsletter_model->Request('origine',$res->chapitre_id);
            } 
            elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'nl_categories') {
              $Module       = $this->stat_prg_model->Request('intitule',$res->sequence_id);
              if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {
                $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$res->chapitre_id));
                $Exercice       = $this->newsletter_model->Request('article',$res->chapitre_id);
                $Lien           = $this->newsletter_model->Request('origine',$res->chapitre_id);
              }
            }
            elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'sequence_activite') {
              $Module         = $this->modules_model->Request('module_titre',$res->module_id); 
              $Sequence       = $this->sequence_model->Request('sequence_titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id));
              if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {
                $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id),$res->chapitre_id);
                $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$this->stat_prg_model->Request('id_prg',$res->sequence_id),$res->chapitre_id);
              }
            }  
            else {
              $Module         = $this->classificationFavoris_Model->Request('intitule',$res->module_id);
              $Exercice       = $this->document_model->Request('titre',$res->chapitre_id);
              $Lien           = $this->document_model->Request('fichier',$res->chapitre_id);
            } 
            break;      
          case 25:
            $Parcours       = '';
            $Menu           = 'My educational tools';
            $SousMenu       = 'My connexion speed';  
            break;           
          case 26:
            $Parcours       = '';
            $Menu           = 'My educational tools';
            $SousMenu       = 'White paper';              
          case 30:
            $Parcours       = '';
            $Menu           = 'My educational tools';
            $SousMenu       = 'Conference call';   
            break;              
          case 55:
            $Parcours       = '';
            $Menu           = 'Training period';
            $SousMenu       = 'QCM';   
            break;                
          default:
            # code...
            break;
        }
      }
      $images_quotes = '<img src="assets/icons-f2+/historique_de_cours/ico-arrowright.png" alt="User elearning" class="user-image img-home icons-rigth">';

      if ($Parcours != '') {
        $return .= $Parcours;
      }
      if ($Menu != '') {
        $return .= $images_quotes.$Menu;
      }
      if ($SousMenu != '') {
        $return .= $images_quotes.$SousMenu;
      }
      if ($Module != '') {
        $return .= $images_quotes.$Module;
      }
      if ($Sequence != '') {
        $return .= $images_quotes.$Sequence;
      }
      if ($Exercice != '') {
        $return .= $images_quotes.$Exercice;
      }
      if ($Lien != '') {
        $return .= $images_quotes.$Lien;
      }

      echo $return;
    }


    public function Update($trackingid){
        if ($trackingid == "" || $trackingid == 0 || $trackingid == NULL) {
            $id = $this->session->userdata ('TRACKINGID');
        }
        else{
            $id = $trackingid;
        }
        
        $date = getdate();      
        $date = $date["0"];       

        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_tracking', $id);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $old  = $res->date ;
            $time = $date - $old;
            $trackinginfo = array('time'=>$time,'date_logout'=>$date);
            $this->db->where('id_tracking', $id);
            $this->db->update($this->table, $trackinginfo);
        }
        return $id;

    }

    public function UpdateMaxTrackingByCnxManual($cnx,$date){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_cnx', $cnx);
        $this->db->order_by('id_tracking', 'desc');
        $this->db->limit(1);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $old  = $res->date ;
            $time = $date - $old;
            $trackinginfo = array(
              'time'=>$time,
              'date_logout'=>$date
            );
            $this->db->where('id_cnx', $cnx);
            $this->db->update($this->table, $trackinginfo);
        }
        return true;

    }

    public function UpdateMaxTrackingByCnx($cnx){
        
        $date = getdate();      
        $date = $date["0"];       

        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_cnx', $cnx);
        $this->db->order_by('id_tracking', 'desc');
        $this->db->limit(1);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $old  = $res->date ;
            $time = $date - $old;
            $trackinginfo = array(
              'time'=>$time,
              'date_logout'=>$date
            );
            $this->db->where('id_cnx', $cnx);
            $this->db->update($this->table, $trackinginfo);
        }
        return true;

    }

    public function getMaxIdTracking(){
        $this->db->select('MAX(id_tracking) AS idMax');
        $this->db->from($this->table);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $idMax = $res->idMax + 1;
           
        }
        return $idMax;
    }

    public function delSequence($ids,$idg) {
      
        $grp = '' ;
        if ( $idg != 0 ) {
            $this->db->where('groupe_id', $idg);
        }      
        $this->db->where('sequence_id', $ids);
        $this->db->delete($this->table);
    }

    public function deleteByParams($arrayParams) {
      if (isset($arrayParams['module_id']) && $arrayParams['module_id'] != null) {
        $this->db->where('module_id', $arrayParams['module_id']);
      } 

      if (isset($arrayParams['sequence_id']) && $arrayParams['sequence_id'] != null) {
        $this->db->where('sequence_id', $arrayParams['sequence_id']);
      } 

      if (isset($arrayParams['chapitre_id']) && $arrayParams['chapitre_id'] != null) {
        $this->db->where('chapitre_id', $arrayParams['chapitre_id']);
      }

      if (isset($arrayParams['groupe_id']) && $arrayParams['groupe_id'] != null) {
        $this->db->where('groupe_id', $arrayParams['groupe_id']);
      }

      if (isset($arrayParams['date']) && $arrayParams['date'] != null) {
        $this->db->where('date', $arrayParams['date']);
      }

      if (isset($arrayParams['id_cnx']) && $arrayParams['id_cnx'] != null) {
        $this->db->where('id_cnx', $arrayParams['id_cnx']);
      }


      if (isset($arrayParams['type'])) {
        if (is_array($arrayParams['type'])) {
          $this->db->where_in('type', $arrayParams['type']);
        }
        else{
          $this->db->where('type', $arrayParams['type']);
        }
        
      }            
      
      $this->db->delete($this->table);
    }

    public function del($idu,$ids,$idg,$loc=-1) {

        $this->db->where('user_id', $idu);
        $this->db->where('sequence_id', $ids);
        $this->db->where('groupe_id', $idg);
        if ($loc!=-1) {
           $this->db->where('loc', $loc);
        }
        $this->db->delete($this->table);


        $this->db->where('user_id', $idu);
        $this->db->where('sequence_id', $ids);
        $this->db->where('groupe_id', $idg);       
        $this->db->delete("dd_interactions");


        $this->db->where('user_id', $idu);
        $this->db->where('sequence_id', $ids);
        $this->db->where('groupe_id', $idg);       
        $this->db->delete("dd_objectifs");


        $this->db->where('user_id', $idu);
        $this->db->where('sequence_id', $ids);
        $this->db->where('groupe_id', $idg);       
        $this->db->delete("dd_scorm");

        return true;
    }

    public function delUser($idu,$idg) {

        $this->db->where('user_id', $idu);
        $this->db->where('groupe_id', $idg);
        $this->db->delete($this->table);


        $this->db->where('user_id', $idu);
        $this->db->where('groupe_id', $idg);       
        $this->db->delete("dd_interactions");


        $this->db->where('user_id', $idu);
        $this->db->where('groupe_id', $idg);       
        $this->db->delete("dd_objectifs");


        $this->db->where('user_id', $idu);
        $this->db->where('groupe_id', $idg);       
        $this->db->delete("dd_scorm");

        return true;
    }

    public function delChapitre($ids,$idc) {     

        $this->db->where('sequence_id', $ids);
        $this->db->where('chapitre_id', $idc);
        $this->db->delete($this->table);

        $this->db->where('sequence_id', $ids);
        $this->db->where('chapitre_id', $idc);
        $this->db->delete('dd_interactions');

        $this->db->where('sequence_id', $ids);
        $this->db->where('chapitre_id', $idc);
        $this->db->delete('dd_objectifs');

        $this->db->where('sequence_id', $ids);
        $this->db->where('chapitre_id', $idc);
        $this->db->delete('dd_scorm');

    }

    public function getlatest(){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->group_by('sequence_id');
        $this->db->group_by('chapitre_id');
        $this->db->group_by('type');
        $this->db->order_by('id_tracking', 'desc');
        $this->db->limit(10);
        return $this->db->get();                
    }
    public function mostviewed(){
        $this->db->select('COUNT("id_tracking"), sequence_id ,type');
        $this->db->from($this->table);
        $this->db->group_by('sequence_id');
        $this->db->group_by('chapitre_id');
        $this->db->group_by('type');
        $this->db->order_by('COUNT("id_tracking")', 'desc');
        $this->db->limit(10);
        return $this->db->get();                
    }

    public function getStagiaireTracking($cnx, $idu, $idg,$page,$segment) {
        $ret = Array() ;
        $i=0 ;
        $this->db->select("date(FROM_unixtime(t.`date`)) as `date` , time(FROM_unixtime(t.`date`)) as `heure`,t.time as `time`,l.sequence_titre as sequence, s.titre as exercice");
        $this->db->from($this->table.' as t');
        $this->db->join($this->table_seq.' as s', 's.numero=t.chapitre_id AND s.id_sequence=t.sequence_id','inner');
        $this->db->join($this->table_list_seq.' as l', 'l.sequence_id=t.sequence_id','inner');
        $this->db->where('t.id_cnx', $cnx);
        $this->db->where('t.user_id', $idu);
        $this->db->where('t.groupe_id', $idg);
        $this->db->limit($page, $segment);
        $query = $this->db->get();    
        $ret['cnt']= $query->num_rows();    
        $result =  $query->result();
        foreach ($result as $res){
            $ret[$i]['date']         = $res->date ;
            $ret[$i]['heure']        = $res->heure ;
            $ret[$i]['activite']     = '';
            //$ret[$i]['activite']     = $res->activitee;
            $ret[$i]['time']         = $res->time;
            $ret[$i]['sequence']     = $res->sequence;
            $ret[$i++]['exercice']   = $res->exercice;       
            $i++ ;
           
        }
        return($ret);
    }
    public function getCountStagiaireTracking($cnx, $idu, $idg) {
        $this->db->select("date(FROM_unixtime(t.`date`)) as `date` , time(FROM_unixtime(t.`date`)) as `heure`,t.time as `time`,l.sequence_titre as sequence, s.titre as exercice");
        $this->db->from($this->table.' as t');
        $this->db->join($this->table_seq.' as s', 's.numero=t.chapitre_id AND s.id_sequence=t.sequence_id','inner');
        $this->db->join($this->table_list_seq.' as l', 'l.sequence_id=t.sequence_id','inner');
        $this->db->where('t.id_cnx', $cnx);
        $this->db->where('t.user_id', $idu);
        $this->db->where('t.groupe_id', $idg);
        $query = $this->db->get(); 
        return $query->num_rows();    
    }

    public function getNbConsultsByIdNum($idSequence,$numero){
        $this->db->select('COUNT(id_tracking) AS nbConsult');
        $this->db->from($this->table);    
        $this->db->where('sequence_id', $idSequence);  
        $this->db->where('chapitre_id', $numero);          
        $this->db->where_in('type', array(7,8));          
        $query = $this->db->get();  
        $result =  $query->result();
        foreach ($result as $res){
            return $res->nbConsult;
           
        }
    }

    public function getDateLastConsultByIdSequenceAndNummero($idSequence,$numero){
        $this->db->select('DATE(FROM_UNIXTIME(MAX(date))) AS dateLastConult');
        $this->db->from($this->table);    
        $this->db->where('sequence_id', $idSequence);  
        $this->db->where('chapitre_id', $numero); 
        $this->db->where_in('type', array(7,8));          
        $query = $this->db->get();  
        $result =  $query->result();
        foreach ($result as $res){
            return $res->dateLastConult;
           
        }
    }

    public function getDateLastConsultByIdNum($idSequence,$numero){
        $this->db->select('MAX(date) AS dateLastConult');
        $this->db->from($this->table);    
        $this->db->where('sequence_id', $idSequence);  
        $this->db->where('chapitre_id', $numero);         
        $query = $this->db->get();  
        $result =  $query->result();
        foreach ($result as $res){
            return $res->dateLastConult;
           
        }
    }

    public function getAllActivityByCnx($cnx){
        $this->db->select('*');
        $this->db->from($this->table);    
        $this->db->where('id_cnx', $cnx);      
        $query = $this->db->get();  
        return $query->result();
    }

    public function getLastClickForEndSession($cnx){
        $this->db->select('date AS DateDernierClick');
        $this->db->from($this->table);    
        $this->db->where('id_cnx', $cnx); 
        $this->db->order_by('id_tracking', 'desc');
        $this->db->limit(1);       
        $query = $this->db->get();  
        $result =  $query->result();
        foreach ($result as $res){
            return $res->DateDernierClick;
           
        }
    }

    public function getLastClickForUser($user_id){
        $this->db->select('date AS DateDernierClick');
        $this->db->from($this->table);    
        $this->db->where('user_id', $user_id); 
        $this->db->order_by('id_tracking', 'desc');
        $this->db->limit(1);       
        $query = $this->db->get();  
        $result =  $query->result();
        foreach ($result as $res){
            return $res->DateDernierClick;
           
        }
    }

    public function getDernierClick($id_cnx){
        $this->db->select('TIME(FROM_UNIXTIME(MAX(date))) AS dernierClick');
        $this->db->from($this->table);    
        $this->db->where('id_cnx', $id_cnx); 
        $query = $this->db->get();  
        $result =  $query->result();
        foreach ($result as $res){
            return $res->dernierClick;
           
        }
    }

    public function deleteByModuleSequenceType($module_id, $sequence_id, $arrayType){
      $this->db->where('module_id', $module_id);
      $this->db->where('sequence_id', $sequence_id);
      $this->db->where_in('type', $arrayType);
      $this->db->delete($this->table);
    }
}

?>
