function getUrlParameter(sParam) {
    var sPageURL = window.location.search.substring(1),
      sURLVariables = sPageURL.split('&'),
      sParameterName,
      i;

    for (i = 0; i < sURLVariables.length; i++) {
        sParameterName = sURLVariables[i].split('=');

        if (sParameterName[0] === sParam) {
            return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
        }
    }
    return false;
};
$(document).ready(function() {
    //datepicker
    $('.date_debut').datepicker({
        dateFormat: "dd/mm/yy",
    });
    $('input[name=text9]').datepicker({
        dateFormat: "dd/mm/yy",
    });
    $('.date_fin').datepicker({
        dateFormat: "dd/mm/yy",
    });
    

    var listDocs = $('#listdocs').DataTable({
        "ordering": false,
        "columnDefs": [{
                "targets": [1],
                "visible": false,
                "searchable": false
            },
            {
                "targets": [3],
                "visible": false
            },
            {
                "targets": [11],
                "visible": false
            }
        ]
    });

    
    $('.input-sm').on( 'keyup', function () {
        listDocs.search( this.value ).draw();
        
    } );

    listDocs.on( 'draw', function () {
        $('#listdocs_paginate').show();
        $('#listdocs_info').show();
        $('.checkbox_document_line').show();
        $('.dataTables_paginate').show();
    });

    if ($('.dataTables_paginate').length == '1') {
        $('#listdocs_paginate').hide();
        $('#listdocs_info').hide();
    }

    $('#filter').on('click', function(e) {
        e.preventDefault();
        var startDate = $('#start').val();
        var endDate = $('#end').val();
        var linkExport = $('#exportData').attr('href');
        $('#exportData').attr('href', linkExport + "&date_debut=" + startDate + "&date_fin=" + endDate);

        filterByDate(9, startDate, endDate);

        listDocs.draw();
    });

    $('#clearFilter').on('click', function(e) {
        e.preventDefault();
        console.log('reset');
        $.fn.dataTableExt.afnFiltering.length = 0;
        listDocs.draw();

    });

    var filterByDate = function(column, startDate, endDate) {

        $.fn.dataTable.ext.search.push(
            function(oSettings, aData, iDataIndex) {
                var rowDate = normalizeDate(aData[column]);
                var start = normalizeDate(startDate);
                var end = normalizeDate(endDate);

                console.log(start + '  ' + end + ' ' + rowDate);

                // If our date from the row is between the start and end
                if (start <= rowDate && rowDate <= end) {
                    return true;
                } else if (rowDate >= start && end === '' && start !== '') {
                    return true;
                } else if (rowDate <= end && start === '' && end !== '') {
                    return true;
                } else {
                    return false;
                }
            }
        );
    };


    var normalizeDate = function(dateString) {

        var correctFormat = dateString.replace(/(\d+)\/(\d+)\/(\d+)/, "$3/$2/$1");
        var date = new Date(correctFormat);
        var normalized = date.getFullYear() + '' + (("0" + (date.getMonth() + 1)).slice(-2)) + '' + ("0" + date.getDate()).slice(-2);

        return normalized;
    }

    $('.export').on('click', function() {
        //number of filtered rows
        var datas = [];
        var result = listDocs.rows({ filter: 'applied' }).data();
        var i = 0;
        result.each(function(key, value) {
            datas[i] = key;
            i++;
        });
        //console.log(datas);
        $("#loader").show();

        $.ajax({
            type: "POST",
            url: '../export_doc_stagiaire.php',
            data: { json: JSON.stringify(datas) },
            dataType: 'json',
            success: function(data, statut) {
                console.log(data);
                console.log(statut);
            },
            complete: function(data) {
                $("#loader").hide();
                console.log(data);

                var contentType = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
                var csvFile = new Blob([data.responseText], { type: contentType });
                var downloadUrl = window.URL.createObjectURL(csvFile);
                var a = document.createElement("a");
                a.href = downloadUrl;
                a.download = "export_doctosign.xls";
                document.body.appendChild(a);
                a.click();

            },
            error: function(data, statut, erreur) {

                console.log(erreur);
            }
        });


    });

    /*
     * eof datatable
     */
     $('input.checkboxfiles').click(function() {
        var inputValue = $(this).attr("value");

        if ($(this).is(':checked')) {
            $("#file_" + inputValue).show();
            $("#file_" + inputValue).find('.hidden_pj').removeAttr('disabled');
        } else {
            $("#file_" + inputValue).hide();
            $("#file_" + inputValue).find('.hidden_pj').attr('disabled', true);
        }

    });

     


    var statut = getUrlParameter('status_envoi_mail');
    var message_retour = "";
    if (statut == "1") {
        message_retour += "Mail envoyé avec succés";
    } else if (statut == "0") {
        message_retour += "Mail non envoyé !! <br> Veuillez verifier vos parametres d'envoi";
    } else if (statut == "") {
        message_retour += "";
    } else {
        message_retour += "";
    }


    if (message_retour != "") {
        $('.message_envoi').text(message_retour).fadeIn('slow', 5000, function() { $(this).fadeOut().empty(); });
    }
    //$('.search_to_to_sign').prepend("<div class='message_envoi'>"+message_retour+"</div>").fadeIn('slow',5000, function() { $(this).fadeOut().empty();});


    /*control datalis from stagiare*/

    $("#searchstudentId").change(function() {
        var val = $('#searchstudentId').val()
        var idStagiaire = $('#searchstudent option').filter(function() {
            return this.value == val;
        }).data('id');
        $('#valreturns').val(idStagiaire);
    });


    /*
     * envoi 
     */
    $('.adresse_destinataire').after('<div id="field"><button class="btn btn-succes addCc">Add Cc</button></div>');
    $('.numero_recipent').after('<div id="fieldnum"><button class="btn btn-succes addNum">Add Num</button></div>')
    var nextedu = 0;

    $('.addCc').on('click', function(e) {
        e.preventDefault();
        var addto = "#field";
        nextedu = nextedu + 1;
        var newIn = ' <div class="form-group" id="field' + nextedu + '" name="field' + nextedu + '"><input class="adresse_destinataire form-control" name="mailCc[]" type="email" maxlength="90" size="30" value="" placeholder="Cc"></div>';

        var newInput = $(newIn);
        var addRemove = "#field" + nextedu;

        var removeBtn = '<button id="remove' + (nextedu) + '" class="btn btn-danger remove-me" >Supprimer</button>';
        var removeButton = $(removeBtn);
        $(addto).append(newInput);
        $(addRemove).after(removeButton);
        $("#field" + nextedu).attr('data-source', $(addto).attr('data-source'));
        $("#count").val(nextedu);

        $('.remove-me').click(function(e) {
            e.preventDefault();
            var fieldNum = this.id.charAt(this.id.length - 1);
            var fieldID = "#field" + fieldNum;
            $(this).remove();
            $(fieldID).remove();
        });

    });

    $('.addNum').on('click', function(e) {
        e.preventDefault();
        var addto = "#fieldnum";
        nextedu = nextedu + 1;
        var newIn = ' <div class="form-group" id="fieldnum' + nextedu + '" name="field' + nextedu + '"><input class="numero_recipent form-control" name="Addrecipients[]" type="text" maxlength="90" size="30" value="" placeholder=""></div>';

        var newInput = $(newIn);
        var addRemove = "#fieldnum" + nextedu;

        var removeBtn = '<button id="remove' + (nextedu) + '" class="btn btn-danger remove-me" >Supprimer</button>';
        var removeButton = $(removeBtn);
        $(addto).append(newInput);
        $(addRemove).after(removeButton);
        $("#fieldnum" + nextedu).attr('data-source', $(addto).attr('data-source'));
        $("#count").val(nextedu);

        $('.remove-me').click(function(e) {
            e.preventDefault();
            var fieldNum = this.id.charAt(this.id.length - 1);
            var fieldID = "#fieldnum" + fieldNum;
            $(this).remove();
            $(fieldID).remove();
        });

    });

    $('.btn-delete-check').click(function(){
        var btn = $(this);
        var allVals = [];  
        $("input[name=doc_checkbox]:checked").each(function(){
            if (this.checked == true){
                allVals.push($(this).attr('data-id'));
                $.ajax({
                    type: "GET",
                    url: 'deldoctosign/'+$(this).val(),                   
                    success: function(data) {    
                        console.log(data);
                        if (data != '') {
                            $(this).parents('.checkbox_document').parents('.checkbox_document_line').remove();
                        }                  
                    }
                });
            }           
        });
        if(allVals.length <=0)  
        {  
        alert("Please select row.");  
        }  
        else {
            $.each(allVals, function( index, value ) {
                $('#listdocs tr').filter("[data-row-id='" + value + "']").hide();
                listDocs.draw();
            });
        }

    });

});

function loadDoc(id){
    url = window.location.href+"&action=modif&id="+id;
    $(location).attr("href", url);
}
function check_doc(line){
    var nb_doc_checked = $( "input[name=doc_checkbox]:checked" ).length;
   
    $(line).parents('.checkbox_document').parents('.checkbox_document_line').attr('data-row-id',$(line).attr('data-id'));
    if($(line).is(':checked',true))  
    {
        $(line).prop('checked', true);  
        $('.btn-delete-check').show();
    }  
    else  
    {  
        $(line).prop('checked',false);  
        if (nb_doc_checked >= "1") {
            $('.btn-delete-check').show();
        }
        else{
            $('.btn-delete-check').hide();
        }
    } 
}