var LOREM_IPSUM = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.';

// obtain iframemanager object
var manager = iframemanager();

// obtain cookieconsent plugin
var cc = initCookieConsent();

// Configure with youtube embed
manager.run({
    currLang: 'en',
    services : {
        youtube : {
            embedUrl: 'https://www.youtube-nocookie.com/embed/{data-id}',
            thumbnailUrl: 'https://i3.ytimg.com/vi/{data-id}/hqdefault.jpg',
            iframe : {
                allow : 'accelerometer; encrypted-media; gyroscope; picture-in-picture; fullscreen;',
            },
            cookie : {
                name : 'cc_youtube'
            },
            languages : {
                en : {
                    notice: 'This content is hosted by a third party. By showing the external content you accept the <a rel="noreferrer" href="https://www.youtube.com/t/terms" title="Terms and conditions" target="_blank">terms and conditions</a> of youtube.com.',
                    loadBtn: 'Load video',
                    loadAllBtn: 'Don\'t ask again'
                }
            }
        }
    }
});

// run plugin with config object
cc.run({
    current_lang: 'en',
    autoclear_cookies: true,                    // default: false
    cookie_name: 'cc_cookie_demo2',             // default: 'cc_cookie'
    cookie_expiration: 365,                     // default: 182
    // page_scripts: false,                         // default: false
    force_consent: true,                        // default: false

    // auto_language: null,                     // default: null; could also be 'browser' or 'document'
    // autorun: true,                           // default: true
    // delay: 0,                                // default: 0
    // hide_from_bots: false,                   // default: false
    // remove_cookie_tables: false              // default: false
    // cookie_domain: location.hostname,        // default: current domain
    // cookie_path: '/',                        // default: root
    // cookie_same_site: 'Lax',
    // use_rfc_cookie: false,                   // default: false
    // revision: 0,                             // default: 0

    gui_options: {
        consent_modal: {
            layout: 'cloud',                    // box,cloud,bar
            position: 'bottom center',          // bottom,middle,top + left,right,center
            transition: 'slide'                 // zoom,slide
        },
        settings_modal: {
            layout: 'bar',                      // box,bar
            position: 'left',                   // right,left (available only if bar layout selected)
            transition: 'slide'                 // zoom,slide
        }
    },

    onFirstAction: function(){
        //console.log('onFirstAction fired');
    },

    onAccept: function(){
        //console.log('onAccept fired!')

        // If analytics category is disabled => load all iframes automatically
        if(cc.allowedCategory('analytics')){
            //console.log('iframemanager: loading all iframes');
            manager.acceptService('all');
        }
    },

    onChange: function (cookie, changed_preferences) {
        //console.log('onChange fired!');

        // If analytics category is disabled => ask for permission to load iframes
        if(!cc.allowedCategory('analytics')){
            //console.log('iframemanager: disabling all iframes');
            manager.rejectService('all');
        }else{
            //console.log('iframemanager: loading all iframes');
            manager.acceptService('all');
        }
    },

    languages: {
        'en': {
            consent_modal: {
                title: 'Votre vie privée',
                description: 'Nous utilisons des cookies et d\'autres technologies similaires afin de personnaliser notre contenu, mesurer l\'efficacité de nos publicités et améliorer leur pertinence, ainsi que proposer une meilleure expérience. En cliquant sur OK ou en activant une option dans Préférences de cookies, vous acceptez les conditions énoncées par la <a href="https://www.cnil.fr/fr/donnees-personnelles" class="cc-link" target="_blank">Politique en matière de cookies</a>. Pour modifier vos préférences ou retirer votre consentement, vous devez mettre à jour vos Préférences de cookies.',
                primary_btn: {
                    text: 'Accepter tout',
                    role: 'accept_all'      //'accept_selected' or 'accept_all'
                },
                secondary_btn: {
                    text: 'Préférences de cookies',
                    role: 'settings'       //'settings' or 'accept_necessary'
                },
                revision_message: '<br><br> Dear user, terms and conditions have changed since the last time you visisted!'
            },
            settings_modal: {
                title: 'Votre confidentialité',
                save_settings_btn: 'Enregistrer la sélection actuelle',
                accept_all_btn: 'Accepter tout',
                reject_all_btn: 'Rejeter tout',
                close_btn_label: 'Close',
                cookie_table_headers: [
                    {col1: 'Name'},
                    {col2: 'Domain'},
                    {col3: 'Expiration'}
                ],
                blocks: [
                    {
                        description: 'Lorsque vous consultez un site web, certaines informations peuvent être stockées ou récupérées, principalement sous la forme de cookies. Ces informations peuvent être relatives à vos préférences, à l\'appareil que vous utilisez ou vous concerner personnellement. Elles sont principalement utilisées pour faire en sorte que le site fonctionne conformément à vos attentes. Elles ne permettent généralement pas de vous identifier directement, mais elles peuvent vous offrir une expérience de navigation plus personnalisée sur le site. Comme nous respectons votre droit à la vie privée, vous pouvez choisir de ne pas autoriser certains types de cookies. Cliquez sur les différents en-têtes de catégorie pour en savoir plus et modifier nos paramètres par défaut. Sachez toutefois que le blocage de certains types de cookies peut avoir un impact sur votre utilisation du site et sur les services que nous pouvons offrir.'
                    }, {
                        title: 'Cookies strictement nécessaires',
                        description: 'Ces cookies sont nécessaires au fonctionnement du site web et ne peuvent être désactivés dans nos systèmes. Ils sont généralement uniquement déposés en réponse à des actions de votre part correspondant à une demande de services, comme définir vos préférences de confidentialité, vous connecter ou remplir des formulaires. Vous pouvez configurer votre navigateur pour qu\'il bloque ces cookies ou vous signale leur présence, mais certaines parties du site risquent alors de ne pas fonctionner.',
                        toggle: {
                            value: 'necessary',
                            enabled: true,
                            readonly: true  //cookie categories with readonly=true are all treated as "necessary cookies"
                        }
                    }, 
                    {
                        title: 'Google analytics',
                        //description: LOREM_IPSUM,
                        toggle: {
                            value: 'analytics',
                            enabled: false,
                            readonly: false
                        },
                        cookie_table: [
                            /*{
                                col1: '^_ga',
                                col2: 'yourdomain.com',
                                col3: 'description ...',
                                is_regex: true
                            },
                            {
                                col1: '_gid',
                                col2: 'yourdomain.com',
                                col3: 'description ...',
                            },
                            {
                                col1: 'cc_youtube',
                                col2: 'yourdomain.com',
                                col3: 'Cookie set by iframemanager'
                            }*/
                        ]
                    },

                    {
                        title: 'Fonctionnalités facebook',
                        //description: LOREM_IPSUM,
                        toggle: {
                            value: 'facebook',
                            enabled: false,
                            readonly: false
                        },
                        cookie_table: [
                            /*{
                                col1: '^_ga',
                                col2: 'yourdomain.com',
                                col3: 'description ...',
                                is_regex: true
                            },
                            {
                                col1: '_gid',
                                col2: 'yourdomain.com',
                                col3: 'description ...',
                            },
                            {
                                col1: 'cc_youtube',
                                col2: 'yourdomain.com',
                                col3: 'Cookie set by iframemanager'
                            }*/
                        ]
                    },

                    {
                        title: 'Youtube',
                        //description: LOREM_IPSUM,
                        toggle: {
                            value: 'youtube',
                            enabled: false,
                            readonly: false
                        },
                        cookie_table: [
                            /*{
                                col1: '^_ga',
                                col2: 'yourdomain.com',
                                col3: 'description ...',
                                is_regex: true
                            },
                            {
                                col1: '_gid',
                                col2: 'yourdomain.com',
                                col3: 'description ...',
                            },
                            {
                                col1: 'cc_youtube',
                                col2: 'yourdomain.com',
                                col3: 'Cookie set by iframemanager'
                            }*/
                        ]
                    }
                ]
            }
        }
    }
});