refreshDataUserConnected();

function filterGlobal() {
    $('.connected-users')
        .DataTable()
        .search($('#global_filter').val())
        .draw();
}
 
function filterColumn(i) {
    $('.connected-users')
        .DataTable()
        .column(i)
        .search(
            $('#col' + i + '_filter').val(),
            /*$('#col' + i + '_regex').prop('checked'),
            $('#col' + i + '_smart').prop('checked')*/
        )
        .draw();
}
function displayClock() {
    // Récupérer l'heure actuelle >> instancier l'objet Date
    var today = new Date();
    // Récupérer les heures, les minutes et les secondes
    var hours = today.getHours();
    var minutes = today.getMinutes();
    var seconds = today.getSeconds();
    if(hours < 10) {
        hours = '0' + hours;
    }
    if(minutes < 10){
        minutes = '0' + minutes;
    }
    if(seconds < 10){
        seconds = '0' + seconds;
    }
    // Afficher l'horloge 
    $('.clock').html(hours + ':' + minutes + ':' + seconds);
}
 
function refreshDataUserConnected() {
    $('.line-connexion-detail').each(function(){
        var line          = $(this);
        var traineeId     = line.attr('data-trainee-id');
        var traineeStatus = line.attr('data-class-info-cnx');
        var btnactions    = '';
        if (traineeStatus != 'deconnecter') {
            $.ajax({
                url      : $('.baseURL').val()+'refresh-data-user-connected',
                type     : 'POST', 
                data     : {traineeId : traineeId},
                dataType : "json",    
                success  : function(data){ 
                    //console.log(data);
                    if (typeof(data.labeStatusCnx) != "undefined" && data.labeStatusCnx !== null) {
                        line.find('.status-connexion').html('<span class="'+data.classSatusCnx+'">'+data.labeStatusCnx+'</span>');
                    }

                    if (typeof(data.debutConnexionEl) != "undefined" && data.debutConnexionEl !== null) {
                        line.find('.startConnexion').html(data.debutConnexionEl);
                    }

                    if (typeof(data.finConnexionEl) != "undefined" && data.finConnexionEl !== null) {
                        line.find('.end-connexion').html(data.finConnexionEl);
                    }

                    if (typeof(data.derniereClick) != "undefined" && data.derniereClick !== null) {
                        line.find('.endClick').html(data.derniereClick);
                    }


                    if (typeof(data.dernierCnx) != "undefined" && data.dernierCnx !== null) {
                        line.find('.last-connex-el').html(data.dernierCnx);
                    }
                    
                    if (typeof(data.dernierActivite) != "undefined" && data.dernierActivite !== null) {
                        line.find('.endActivity').html(data.dernierActivite);
                    }

                    if (typeof(data.navigateur) != "undefined" && data.navigateur !== null) {
                        line.find('.navigatorTrainee').html(data.navigateur);
                    }

                    if (typeof(data.plateforme) != "undefined" && data.plateforme !== null) {
                        line.find('.platformTrainee').html(data.plateforme);
                    }

                    if (typeof(data.actionNormalDeconnexion) != "undefined" && data.actionNormalDeconnexion !== null) {
                        btnactions += data.actionNormalDeconnexion;
                    }

                    if (typeof(data.actionLastDeconnexion) != "undefined" && data.actionLastDeconnexion !== null) {
                        btnactions += data.actionLastDeconnexion;
                    }

                    if (btnactions != '') {
                        line.find('.case-btn-action').html(btnactions);
                    }
                    
                }
            });
        }
    });  
    setTimeout(refreshDataUserConnected, 10000); //refresh toutes secondes (1 minute = 60000) la on est à 3 seconde
}

$(document).ready(function () {
    displayClock();
    setInterval(displayClock, 1000);

   


    var tableUserConnected = $('.connected-users').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'excel', 'pdf'
        ],
        orderCellsTop: true,
        fixedHeader: true,
        responsive: true,
        "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
        "paging": false,//Dont want paging                
        "bPaginate": false,//Dont want paging   
    });
     
     
    $('input.global_filter').on('keyup click', function () {
        filterGlobal();
        changeRowsTable(tableUserConnected);
    });
 
    $('.btn-clear-filter').on('click', function (e) {
        e.preventDefault();        
        $('.column_filter').each(function(){
            var columns = $(this);
            tableUserConnected.column(columns.parents('.filter-container').attr('data-column')).search('').draw();
        });
        $('.creneauhoraire').val('');
        $('.statusconnexion').val('');
        $('input.column_filter').val('');
        changeRowsTable(tableUserConnected);
    });

    $('.trainee_filter').on('keyup click', function () {
        var dataFIlter = $(this);
        var column = dataFIlter.parents('.filter-container').attr('data-column');
        if (dataFIlter.val() != '') {
            tableUserConnected.column(column).search(dataFIlter.val()).draw();
        }
        else{
            tableUserConnected.column(column).search('').draw();
        }
        changeRowsTable(tableUserConnected);
    });

    $('.creneauhoraire, .statusconnexion, .trainer').on('change', function () {
        var dataFIlter = $(this);
        var column = dataFIlter.parents('.filter-container').attr('data-column');
        if (dataFIlter.val() != '') {
            filterColumn(column);
        }
        else{
            tableUserConnected.column(column).search('').draw();
        }
        changeRowsTable(tableUserConnected);
    });

    
    /*$('.statusconnexion').on('change', function () {        
        var dataFIlter = $(this);
        var column = dataFIlter.parents('.filter-container').attr('data-column');
        console.log('value : ' + dataFIlter.val());
        console.log('column : ' + column);
        if (dataFIlter.val() != '') {
            filterColumn(column);
        }
        else{
            tableUserConnected.column(column).search('').draw();
        }
    });*/



    /*$('.connected-users thead tr')
        .clone(true)
        .addClass('filters filter-users-connected')
        .appendTo('.connected-users thead');
 
    var table = $('.connected-users').DataTable({
        "searching": true,
        dom: 'Bfrtip',
        buttons: [
            'excel', 'pdf'
        ],
        scrollY: 400,
        paging: false,
        orderCellsTop: true,
        fixedHeader: true,
        responsive: true,
        initComplete: function () {
            var api = this.api();
            api
                .columns()
                .eq(0)
                .each(function (colIdx) {
                    // Set the header cell to contain the input element
                    var cell = $('.filters th').eq(
                        $(api.column(colIdx).header()).index()
                    );
                    var title = $(cell).text();
                    $(cell).html('<input type="text" class="form-search-data'+$(cell).index()+'" placeholder="' + title + '" />');
                    //$(cell).index() > 0 ? $(cell).html('<input type="text" class="form-search-data'+$(cell).index()+'" placeholder="' + title + '" />') : '';

                    // On every keypress in this input
                    $(
                        'input',
                        $('.filters th').eq($(api.column(colIdx).header()).index())
                    )
                        .off('keyup change')
                        .on('change', function (e) {
                            // Get the search value
                            $(this).attr('title', $(this).val());
                            var regexr = '({search})'; //$(this).parents('th').find('select').val();

                            var cursorPosition = this.selectionStart;
                            // Search the column for that value
                            api
                                .column(colIdx)
                                .search(
                                    this.value != ''
                                        ? regexr.replace('{search}', '(((' + this.value + ')))')
                                        : '',
                                    this.value != '',
                                    this.value == ''
                                )
                                .draw();
                        })
                        .on('keyup', function (e) {
                            e.stopPropagation();

                            $(this).trigger('change');
                            $(this)
                                .focus()[0]
                                .setSelectionRange(cursorPosition, cursorPosition);
                        });
                });
        },
    });*/
    
});
window.onload = function() {
    $('.hologe_picker_time').each(function(){
    	//horloge
        var i = 1;
        var time_cnx  = $(this).attr('data-time-cnx');
        date = new Date(time_cnx * 1000  - (1*60*60*1000));
        h = date.getHours();
        if(h<10)
        {
                h = "0"+h;
        }
        m = date.getMinutes();
        if(m<10)
        {
                m = "0"+m;
        }
        s = date.getSeconds();
        if(s<10)
        {
                s = "0"+s;
        }

        resultat = h+':'+m+':'+s;
        
        var timecxp = Math.floor(Number(time_cnx)+i);
        $(this).attr('data-time-cnx',timecxp);
        $(this).text(resultat);
        setTimeout('horloge_date_heure("'+$(this).attr('id')+'");','1000');
        return true;
        
    });
    $('.connexion_duration').each(function(){
    
        //duraction connexion

        //console.log($(this).text());
        var y = 1;
        var time_cnx_duration  = $(this).attr('data-time-cnx');
        date_duration = new Date(time_cnx_duration * 1000  - (1*60*60*1000));

        h_duration = date_duration.getHours();

        //console.log(h_duration);
        if(h_duration<10)
        {
                h_duration = "0"+h_duration;
        }
        m_duration = date_duration.getMinutes();
        if(m_duration<10)
        {
                m_duration = "0"+m_duration;
        }
        s_duration = date_duration.getSeconds();
        if(s_duration<10)
        {
                s_duration = "0"+s_duration;
        }

        resultat_duration = h_duration+':'+m_duration+':'+s_duration;
        var timecxp_duration = Math.floor(Number(time_cnx_duration)+y);

        $(this).text(timecxp_duration);
        setTimeout('horloge_date_heure_duration("'+$(this).attr('id')+'");','1000');
        return true;
        
    });
}
function disconnect(line){
    $('.spinner').fadeIn('slow');
    var btn = $(line);
    var msg = '';
    var closeAlert = '<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>';
    $.ajax({
        url : $('.baseURL').val()+"disconnect-manual",
        type:'POST',
        data:{cnx:btn.attr('data-cnx')},        
        dataType:'json',
        success:function(data){
            console.log(data);
            btn.parents('.case-btn-action').parents('.line-connexion-detail').find('.time-cnx').html(data.dureeCnx);
            btn.parents('.case-btn-action').parents('.line-connexion-detail').find('.end-connexion').html(data.finCnx);
            btn.parents('.case-btn-action').parents('.line-connexion-detail').find('.last-connex-el').html(data.dateDebutCnx+' '+data.finCnx);
            btn.parents('.case-btn-action').parents('.line-connexion-detail').find('.status-connexion').html('<span class="deconnecter">Deconnecté</span>');
            btn.fadeOut('slow');
            msg += '<div class="alert alert-info alert-dismissible">'+closeAlert+'Le stagiaire '+btn.parents('.case-btn-action').parents('.line-connexion-detail').find('.trainee-name').text()+' à été déconnecter de la plateforme.'+"</div>";

            if (msg != '') {
                $('.notification').html(msg);
                $('.notification').show('slow');
                setTimeout("$('.notification').hide('slow')",4000); 
            }
            $('.spinner').fadeOut('slow');
    }
    });
    return false;
}
function horloge_date_heure_duration(id)
{
    var time_cnx = document.getElementById(id).getAttribute("data-time-cnx");
    var i = 1;
    date = new Date(time_cnx * 1000  - (1*60*60*1000));
    j = date.getDate();
    h = date.getHours();
    if(h<10)
    {
            h = "0"+h;
    }
    m = date.getMinutes();
    if(m<10)
    {
            m = "0"+m;
    }
    s = date.getSeconds();
    if(s<10)
    {
            s = "0"+s;
    }
    resultat = h+':'+m+':'+s;
    var timecxp = Math.floor(Number(time_cnx)+i);
    //console.log('t'+i+'  : '+Number(time_cnx)+i);
    document.getElementById(id).setAttribute("data-time-cnx",timecxp);
    document.getElementById(id).innerHTML = resultat;
    setTimeout('horloge_date_heure_duration("'+id+'");','1000');
    i++;
    return true;
    
}
function horloge_date_heure(id)
{
    var time_cnx = document.getElementById(id).getAttribute("data-time-cnx");
    var i = 1;
    date = new Date(time_cnx * 1000  - (1*60*60*1000));
    j = date.getDate();
    h = date.getHours();
    if(h<10)
    {
            h = "0"+h;
    }
    m = date.getMinutes();
    if(m<10)
    {
            m = "0"+m;
    }
    s = date.getSeconds();
    if(s<10)
    {
            s = "0"+s;
    }
    resultat = h+':'+m+':'+s;
    var timecxp = Math.floor(Number(time_cnx)+i);
    //console.log('t'+i+'  : '+Number(time_cnx)+i);
    document.getElementById(id).setAttribute("data-time-cnx",timecxp);
    document.getElementById(id).innerHTML = resultat;
    setTimeout('horloge_date_heure("'+id+'");','1000');
    i++;
    return true;
    
}

function changeRowsTable(datatable){
    var numRows = datatable.rows( ).count();
    $('.totalRows').text(datatable.page.info().recordsDisplay);
}

function showDetailCnx(line){
    $('.spinner').fadeIn('slow');
    $('.content-trainee-infos-cnx').empty();
    $('.content-trainee-infos-detail-cnx').empty();
    var select = $(line);
    var traineeId = select.attr('data-trainee-id');
    var traineeName = select.attr('data-trainee-name');
    $.ajax({
        url      : $('.baseURL').val()+'get-infos-trainee-cnx',
        type     : 'POST', 
        data     : {traineeId : traineeId},
        dataType : "json",    
        success  : function(data){
            console.log(data);
            var dataTable = htmlTableInfosCnx(data);
            var totalCnx = data.length;
            var totalActivite = 0;
            $.each(data, function(i, infoCnx){ 
                totalActivite += infoCnx.connexionInfos['nbActivite'];
            });
            $('.user-cnx-select').html('Détails connexion de <span class="userNameTr">' + traineeName + '</span>   <span class="total-cnx-stat">   -  Total connexion : <span class="totalCnx">'+totalCnx+'</span></span><span class="total-activity-stat"> - Total activité : <span class="totalActivity">'+totalActivite+'</span></span>');
            $('.totalCnx').html(totalCnx);
            $('.totalActivity').html(totalActivite);
            $('.content-trainee-infos-cnx').html(dataTable);
            $('.table-infosCnx').DataTable({
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'pdf'
                ],
                orderCellsTop: true,
                fixedHeader: true,
                responsive: true,
                "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
                "paging": false,//Dont want paging                
                "bPaginate": false,//Dont want paging   
            });
            $('.spinner').fadeOut('slow');
            $('#modal_detail_trainee_cnx').modal();
        },
    });
}

function htmlTableInfosCnx(data){
    var html = '';
    html += '<table class="table table-bordered table-striped table-responsive table-infosCnx" id="table-infosCnx">';
    html += '<thead>';
                html += '<tr>';
                    html += '<th>Id Cnx</th>';
                    html += '<th>Date Cnx</th>';
                    html += '<th>Début Cnx</th>';
                    html += '<th>Duree Cnx</th>';
                    html += '<th>Nav</th>';
                    html += '<th>Plat</th>';
                    html += '<th>Nb Activité</th>';
                html += '</tr>';
    html += '</thead>';
    html += '<tbody>';
    $.each(data, function(i, infoCnx){ 
        $('.content-trainee-infos-detail-cnx').append(htmlTableInfosTracking(infoCnx.connexionInfos['idCnx'],infoCnx.connexionInfos['trackingInfos']));
        $('#'+infoCnx.connexionInfos['idCnx']+'').DataTable({
            /*dom: 'Bfrtip',
            buttons: [
                'excel', 'pdf'
            ],*/
            orderCellsTop: true,
            fixedHeader: false,
            responsive: true,
            "bInfo": false, 
            "paging": false,    
            "bPaginate": false,
        });
        html += '<tr>';
            html += '<td>'+infoCnx.connexionInfos['idCnx']+'</td>';
            html += '<td>'+infoCnx.connexionInfos['dateCnx']+'</td>';
            html += '<td>'+infoCnx.connexionInfos['debutCnx']+'</td>';
            html += '<td>'+infoCnx.connexionInfos['dureeCnx']+'</td>';
            html += '<td>'+infoCnx.connexionInfos['Navigateur']+'</td>';
            html += '<td>'+infoCnx.connexionInfos['Plateforme']+'</td>';
            html += '<td><a class="btn btn-infos btn-action-detail-cnx" title="Voir détails" href="#" data-date="'+infoCnx.connexionInfos['dateCnx']+'" data-cnx="'+infoCnx.connexionInfos['idCnx']+'" onclick="detailTrackingCnx(this);">'+infoCnx.connexionInfos['nbActivite']+'</a></td>';
        html += '</tr>';
    });
    html += '</tbody>';
    html += '</table>';
    return html;
}

function htmlTableInfosTracking(idCnx,data){
    var html = '';
    html += '<table class="table table-bordered table-striped table-responsive table-infosTracking" data-cnx="'+idCnx+'" id="'+idCnx+'">';
    html += '<thead>';
                html += '<tr>';
                    html += '<th>Id track</th>';
                    html += '<th>Date track</th>';
                    html += '<th>Début track</th>';
                    html += '<th>Duree track</th>';
                    html += '<th>Menu track</th>';
                    html += '<th>Sous-menu track</th>';
                    html += '<th>Sequence track</th>';
                    html += '<th>Excercice track</th>';
                html += '</tr>';
    html += '</thead>';
    html += '<tbody>';
    $.each(data, function(i, infosTracking){   
        if (infosTracking['idCnx'] == idCnx) {
            html += '<tr>';
                html += '<td>'+infosTracking['id']+'</td>';
                html += '<td>'+infosTracking['dateTracking']+'</td>';
                html += '<td>'+infosTracking['debutTracking']+'</td>';
                html += '<td>'+infosTracking['dureeTracking']+'</td>';
                html += '<td>'+infosTracking['Menu']+'</td>';
                html += '<td>'+infosTracking['SousMenu']+'</td>';
                html += '<td>'+infosTracking['Sequence']+'</td>';
                html += '<td>'+infosTracking['Exercice']+'</td>';
            html += '</tr>';
        }
    });
    html += '</tbody>';
    html += '</table>';
    return html;
}

function detailTrackingCnx(line){
    $('.spinner').fadeIn('slow');
    var html = '';
    var btn = $(line);
    var cnx = btn.attr('data-cnx');
    $('.detail-cnx-select').html('Tracking de connexion du ' + btn.attr('data-date')+'<a href="#" data-cnx="'+cnx+'" onclick="returnPrecedentPage(this);" class="btn btn-default btn-return"><i class="fa fa-repeat"></i>&nbsp;&nbsp;Retourner à la liste de connexion</a>');
    $('.detail-cnx-select').fadeIn('slow');
    $('#table-infosCnx_wrapper').fadeOut('slow');
    $('.content-trainee-infos-cnx').append($('#'+cnx+'_wrapper').html());
    $('.spinner').fadeOut('slow');
}

function returnPrecedentPage(btn){
    $('.spinner').fadeIn('slow');
    var link = $(btn);
    var cnx = link.attr('data-cnx');
    $('.content-trainee-infos-cnx').find('.row').remove();
    //$('.content-trainee-infos-cnx').find('#'+cnx+'_wrapper').remove();
    $('#table-infosCnx_wrapper').fadeIn('slow');
    link.fadeOut('slow');
    $('.detail-cnx-select').fadeOut('slow');
    $('.spinner').fadeOut('slow');
}