var rowperpage = 5;
$(document).ready(function(){
	$('.tableDocument').each(function(){
        $(this).dataTable({
            columnDefs: [{
            orderable: true,
            className: 'select-checkbox',
            targets: 0
            }],
            select: {
            style: 'os',
            selector: 'td:first-child'
            },            
            language: {
                search:         "",
                searchPlaceholder: "Search in this repertory",
            },
            "lengthChange": false,
        });

        $('.col-sm-12').each(function(){
            if ($(this).html() == '') {
                $(this).remove();
            }
            
        });
        $('.dataTables_filter').each(function(){
            $(this).parents('.col-sm-12').removeClass('col-md-6');           
            $(this).parents('.col-sm-12').addClass('search-document-in-rep'); 
            //$(this).html($(this).find('label').html()); 
            $('.form-control-sm').attr('style','border-radius:21px !important;font-size:12px;font-family: Poppins !important;');     
        });

    });
    $('.glyphicon-reportory-database-document').click(function(e){
        e.preventDefault();
        $('.modal_repository').addClass('open');
    });
    $('.btn-save-new-repertory').click(function(e){
        e.preventDefault();
        $('#loading-bar-spinner').fadeIn('slow');
        var repertory = $('.repertory-document').val();
        var description = $('.description_cat').val();
        /*$('.intitle_cat').text(intitule);*/
        if (repertory == "") {
            $('.notification_modal').html('The field new repertory is required');
            $('#loading-bar-spinner').fadeOut('slow');
            return false;
        }
        else{
            $.ajax({
                url : $('.baseURL').val()+"new-repertory",
                type : 'POST',     
                data : {repertory : repertory , description : description},
                success : function(data){
                    var ret = data.split('##');
                    if (ret[1] >= '1') {
                        $('#id_repertory').val(ret[1]);
                        getData();  
                        $('#loading-bar-spinner').fadeOut('slow');
                    }
                }
            });
        }
    });
    $('.button_submit_add_database_rep').click(function(){
        var databasedocument = [];
        var id_repertory = $('#id_repertory').val();
        $('.table_document_repertory .line_document_rep').find('.check_document_rep').find('.id_document').each(function(){
            if ($(this).is(':checked')) {
                databasedocument.push($(this).val());
                $(this).parents('.check_document_rep').parents('.line_document_rep').hide();
            }
        });
        $.ajax({
        url : $('.baseURL').val()+"update-document-by-rep",
            type:'POST',
            data:{id_repertory:id_repertory,databasedocument:databasedocument},        
            dataType:'json',
            success:function(data){
                getData(); 
                $('#but_next').click(); 
            }
        });
        return false;
    });

    $("#but_prev").click(function(){
        var rowid    = Number($("#txt_rowid").val());
        var allcount = Number($("#txt_allcount").val());
        rowid -= rowperpage;
        if(rowid < 0){
            rowid = 0;
        }
        $("#txt_rowid").val(rowid);
        getData();
    });

    $("#but_next").click(function(){
        var rowid    = Number($("#txt_rowid").val());
        var allcount = Number($("#txt_allcount").val());
        rowid += rowperpage;
        if(rowid <= allcount){
            $("#txt_rowid").val(rowid);
            getData();
        }
    });
    $(".btn-cancel-new-repertory").click(function(){
        $('.close-modal-database-repertory').click();
    });
    $('.button_close_modal_database_rep').click(function(){
        location.reload();
    });
    $('#database_document_repertory').each(function(){
        $(this).treed();
        $(this).find('.branch').find('.indicator').click();
    });

    $('.btn-go-back-repertory').click(function(){
        $('.parent-detail-repertory').show();  
        $('.active-repertory').hide();
        $('.div-detail-repertory').each(function(){
            $(this).hide();
        });
        $('.btn-action-repertory').hide();
    });
    $('.col-repertory').click(function(){
        var rep  = $(this);
        var auto = rep.attr('data-auto');
        var id   = rep.attr('data-id');
        var user_create   = rep.attr('data-create');
        var txt  = rep.find('.repertory_name').text();
        $('.title-repertory-active').html(txt);
        $('.active-repertory').show();
        $('.div-detail-repertory').each(function(){
            var doc = $(this);
            if (doc.attr('data-auto') == auto) {
                $(this).show();
            }
            else{
                $(this).hide();
            }
        });
        $('.id_repertory_edit').val(id);
        $('.repertory-document-edit').val(txt);
        if ($('.current_user').val() == user_create) {        	
	        $('.btn-delete-repertory').attr('data-id',id);
	        $('.btn-edit-repertory').attr('data-id',id);
	        $('.btn-delete-repertory').show();
	        $('.btn-edit-repertory').show();
        }
        else{
        	$('.btn-delete-repertory').hide();
	        $('.btn-edit-repertory').hide();
        }
        $('.btn-go-current-repertory').html('<i class="fa fa-folder"></i>&nbsp;' + txt);
        $('.parent-detail-repertory').hide();
        $('.btn-action-repertory').show();
    });

    $('.btn-delete-repertory').click(function(){
        var btn = $(this);
        $.ajax({
            url : $('.baseURL').val()+"delete-repertory",
            type:'POST',
            data:{id_repertory:btn.attr('data-id')},   
            success:function(response){
                $('.col-repertory').each(function(){
                    if ($(this).attr('data-id') == btn.attr('data-id')) {
                        $(this).hide();
                    }
                });
                $('#loading-bar-spinner').fadeOut('slow');
                $('.notification').html("<p class='delete_notify'>Data delete succefuly</p>");
                $('.notification').show('slow');
                setTimeout("$('.notification').hide('slow')",3000);  
                $('.btn-go-back-repertory').click();
            }
        });

    });
    $('.btn-edit-repertory').click(function(){
        $('.modal_edit_repository').addClass('open');
    });
    $('.btn-cancel-edit-repertory').click(function(){
    	$('.close-modal-database-repertory').click();
    });
     $('.btn-save-edit-repertory').click(function(e){
        e.preventDefault();
        $('#loading-bar-spinner').show();

        var form = $('#form-edit-rep');
        var dataRep=form.serializeArray();
      
        var dataRepjson = {};
        for (i in dataRep) {
            dataRepjson[dataRep[i].name] = dataRep[i].value;
        }
        dataRep=dataRepjson;
        $.ajax({
            url : $('#form-edit-rep').attr('action'),
            type: $('#form-edit-rep').attr('method'),
            data:{dataRep:dataRep},   
            success:function(response){
                $('.btn-go-current-repertory').html('<i class="fa fa-folder"></i>&nbsp;' + $('.repertory-document-edit').val());
                $('#loading-bar-spinner').fadeOut('slow');
                $('.notification').html("<p class='warning_notify'>Repertory modify succefuly</p>");
                $('.notification').show('slow');
                setTimeout("$('.notification').hide('slow')",3000);
                $('.close-modal-database-repertory').click();
            }
        });
    });
});
function getData(){
    $('#loading-bar-spinner').fadeIn('slow');
    var rowid        = $("#txt_rowid").val();
    var allcount     = $("#txt_allcount").val();
    var id_repertory = $('#id_repertory').val();
    console.log('link : ' + $('.baseURL').val()+"get-all-doc-by-all-criteria");
    $.ajax({
        url : $('.baseURL').val()+"get-all-doc-by-all-criteria",
        type:'POST',
        data:{id_repertory:id_repertory,rowid:rowid,rowperpage:rowperpage},        
        dataType:'json',
        success:function(response){
            createTablerow(response);
            $('#loading-bar-spinner').fadeOut('slow');
        }
    });
}
function createTablerow(data){
    $('#form-repertory-document').hide();
    $('#body_table_document_repertory').show();
    var dataLen = data.length;
    $("#emp_table tr:not(:first)").remove();
    for(var i=0; i<dataLen; i++){
        if(i == 0){
            var allcount = data[i]['allcount'];
            $("#txt_allcount").val(allcount);
        }else{
            var id          = data[i]['id'];
            var title       = data[i]['titre'];
            var file        = data[i]['fichier'];
            var repertory               = "";
            if (data[i]['repertory'] == null || data[i]['repertory'] == "") {
                repertory += "No select";
            }
            else{
                repertory += data[i]['repertory'];
            }
            $(".table_document_repertory").append("<tr class='line_document_rep' id='tr_"+i+"'></tr>");
            $("#tr_"+i).append("<td  class='check_document_rep' align='center'><input type='checkbox' name='id_document' class='id_document' value="+id+"></td>"); 
            //$("#tr_"+i).append("<td>"+repertory+"</td>");
            $("#tr_"+i).append("<td align='left'>"+title+"</td>");
            $("#tr_"+i).append("<td align='center'>"+file+"</td>");
        }
    }
}